/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.report.ConsoleOutputFileReporter;
import org.apache.maven.plugin.surefire.report.DirectConsoleOutput;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.StatelessXmlReporter;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.shade.common.org.apache.commons.lang3.StringUtils;

public final class StartupReportConfiguration {
    private final PrintStream originalSystemOut;
    private final PrintStream originalSystemErr;
    private final boolean useFile;
    private final boolean printSummary;
    private final String reportFormat;
    private final String reportNameSuffix;
    private final File statisticsFile;
    private final boolean requiresRunHistory;
    private final boolean redirectTestOutputToFile;
    private final boolean disableXmlReport;
    private final File reportsDirectory;
    private final boolean trimStackTrace;
    private final int rerunFailingTestsCount;
    private final String xsdSchemaLocation;
    private final Map<String, Map<String, List<WrappedReportEntry>>> testClassMethodRunHistory = new ConcurrentHashMap<String, Map<String, List<WrappedReportEntry>>>();
    private final Charset encoding;
    private boolean isForkMode;
    private StatisticsReporter statisticsReporter;

    public StartupReportConfiguration(boolean useFile, boolean printSummary, String reportFormat, boolean redirectTestOutputToFile, boolean disableXmlReport, @Nonnull File reportsDirectory, boolean trimStackTrace, String reportNameSuffix, File statisticsFile, boolean requiresRunHistory, int rerunFailingTestsCount, String xsdSchemaLocation, String encoding, boolean isForkMode) {
        this.useFile = useFile;
        this.printSummary = printSummary;
        this.reportFormat = reportFormat;
        this.redirectTestOutputToFile = redirectTestOutputToFile;
        this.disableXmlReport = disableXmlReport;
        this.reportsDirectory = reportsDirectory;
        this.trimStackTrace = trimStackTrace;
        this.reportNameSuffix = reportNameSuffix;
        this.statisticsFile = statisticsFile;
        this.requiresRunHistory = requiresRunHistory;
        this.originalSystemOut = System.out;
        this.originalSystemErr = System.err;
        this.rerunFailingTestsCount = rerunFailingTestsCount;
        this.xsdSchemaLocation = xsdSchemaLocation;
        String charset = StringUtils.trimToNull(encoding);
        this.encoding = charset == null ? Charset.defaultCharset() : Charset.forName(charset);
        this.isForkMode = isForkMode;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    @Deprecated
    public StatelessXmlReporter instantiateStatelessXmlReporter(Integer forkNumber) {
        assert (forkNumber == null || this.isForkMode);
        ConcurrentHashMap<String, Map<String, List<WrappedReportEntry>>> testClassMethodRunHistory = this.isForkMode ? new ConcurrentHashMap() : this.testClassMethodRunHistory;
        return this.isDisableXmlReport() ? null : new StatelessXmlReporter(this.resolveReportsDirectory(forkNumber), this.reportNameSuffix, this.trimStackTrace, this.rerunFailingTestsCount, testClassMethodRunHistory, this.xsdSchemaLocation);
    }

    public FileReporter instantiateFileReporter(Integer forkNumber) {
        return this.isUseFile() && this.isBriefOrPlainFormat() ? new FileReporter(this.resolveReportsDirectory(forkNumber), this.reportNameSuffix, this.encoding) : null;
    }

    public boolean isBriefOrPlainFormat() {
        String fmt = this.getReportFormat();
        return "brief".equals(fmt) || "plain".equals(fmt);
    }

    public TestcycleConsoleOutputReceiver instantiateConsoleOutputFileReporter(Integer forkNumber) {
        return this.isRedirectTestOutputToFile() ? new ConsoleOutputFileReporter(this.resolveReportsDirectory(forkNumber), this.reportNameSuffix, forkNumber) : new DirectConsoleOutput(this.originalSystemOut, this.originalSystemErr);
    }

    public synchronized StatisticsReporter getStatisticsReporter() {
        if (this.statisticsReporter == null) {
            this.statisticsReporter = this.requiresRunHistory ? new StatisticsReporter(this.statisticsFile) : null;
        }
        return this.statisticsReporter;
    }

    public File getStatisticsFile() {
        return this.statisticsFile;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public boolean isRequiresRunHistory() {
        return this.requiresRunHistory;
    }

    public PrintStream getOriginalSystemOut() {
        return this.originalSystemOut;
    }

    public String getXsdSchemaLocation() {
        return this.xsdSchemaLocation;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public boolean isForkMode() {
        return this.isForkMode;
    }

    private File resolveReportsDirectory(Integer forkNumber) {
        return forkNumber == null ? this.reportsDirectory : SurefireHelper.replaceForkThreadsInPath(this.reportsDirectory, forkNumber);
    }
}

