/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.report.ReporterUtils;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.logging.MessageUtils;

public class TestSetStats {
    private static final String TESTS = "Tests ";
    private static final String RUN = "run: ";
    private static final String TESTS_RUN = "Tests run: ";
    private static final String FAILURES = "Failures: ";
    private static final String ERRORS = "Errors: ";
    private static final String SKIPPED = "Skipped: ";
    private static final String FAILURE_MARKER = " <<< FAILURE!";
    private static final String IN_MARKER = " - in ";
    private static final String COMMA = ", ";
    private final Queue<WrappedReportEntry> reportEntries = new ConcurrentLinkedQueue<WrappedReportEntry>();
    private final boolean trimStackTrace;
    private final boolean plainFormat;
    private long testSetStartAt;
    private long testStartAt;
    private int completedCount;
    private int errors;
    private int failures;
    private int skipped;
    private long lastStartAt;

    public TestSetStats(boolean trimStackTrace, boolean plainFormat) {
        this.trimStackTrace = trimStackTrace;
        this.plainFormat = plainFormat;
    }

    public int getElapsedSinceTestSetStart() {
        return this.testSetStartAt > 0L ? (int)(System.currentTimeMillis() - this.testSetStartAt) : 0;
    }

    public int getElapsedSinceLastStart() {
        return this.lastStartAt > 0L ? (int)(System.currentTimeMillis() - this.lastStartAt) : 0;
    }

    public void testSetStart() {
        this.lastStartAt = this.testSetStartAt = System.currentTimeMillis();
    }

    public void testStart() {
        this.lastStartAt = this.testStartAt = System.currentTimeMillis();
    }

    private long finishTest(WrappedReportEntry reportEntry) {
        Integer elapsedTime;
        this.reportEntries.add(reportEntry);
        this.incrementCompletedCount();
        long testEndAt = System.currentTimeMillis();
        if (this.testStartAt == 0L) {
            this.testStartAt = testEndAt;
        }
        return (elapsedTime = reportEntry.getElapsed()) != null ? (long)elapsedTime.intValue() : testEndAt - this.testStartAt;
    }

    public void testSucceeded(WrappedReportEntry reportEntry) {
        this.finishTest(reportEntry);
    }

    public void testError(WrappedReportEntry reportEntry) {
        ++this.errors;
        this.finishTest(reportEntry);
    }

    public void testFailure(WrappedReportEntry reportEntry) {
        ++this.failures;
        this.finishTest(reportEntry);
    }

    public void testSkipped(WrappedReportEntry reportEntry) {
        ++this.skipped;
        this.finishTest(reportEntry);
    }

    public void reset() {
        this.completedCount = 0;
        this.errors = 0;
        this.failures = 0;
        this.skipped = 0;
        for (WrappedReportEntry entry : this.reportEntries) {
            entry.getStdout().free();
            entry.getStdErr().free();
        }
        this.reportEntries.clear();
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public String elapsedTimeAsString(long runTime) {
        return ReporterUtils.formatElapsedTime(runTime);
    }

    private void incrementCompletedCount() {
        ++this.completedCount;
    }

    public String getTestSetSummary(WrappedReportEntry reportEntry) {
        String summary = TESTS_RUN + this.completedCount + COMMA + FAILURES + this.failures + COMMA + ERRORS + this.errors + COMMA + SKIPPED + this.skipped + COMMA + reportEntry.getElapsedTimeVerbose();
        if (this.failures > 0 || this.errors > 0) {
            summary = summary + FAILURE_MARKER;
        }
        summary = summary + IN_MARKER + reportEntry.getNameWithGroup();
        return summary;
    }

    public String getColoredTestSetSummary(WrappedReportEntry reportEntry) {
        boolean isSuccessful = this.failures == 0 && this.errors == 0 && this.skipped == 0;
        boolean isFailure = this.failures > 0;
        boolean isError = this.errors > 0;
        boolean isFailureOrError = isFailure | isError;
        boolean isSkipped = this.skipped > 0;
        MessageBuilder builder = MessageUtils.buffer();
        if (isSuccessful) {
            if (this.completedCount == 0) {
                builder.strong(TESTS_RUN).strong(this.completedCount);
            } else {
                builder.success(TESTS_RUN).success(this.completedCount);
            }
        } else if (isFailureOrError) {
            builder.failure(TESTS).strong(RUN).strong(this.completedCount);
        } else {
            builder.warning(TESTS).strong(RUN).strong(this.completedCount);
        }
        builder.a(COMMA);
        if (isFailure) {
            builder.failure(FAILURES).failure(this.failures);
        } else {
            builder.a(FAILURES).a(this.failures);
        }
        builder.a(COMMA);
        if (isError) {
            builder.failure(ERRORS).failure(this.errors);
        } else {
            builder.a(ERRORS).a(this.errors);
        }
        builder.a(COMMA);
        if (isSkipped) {
            builder.warning(SKIPPED).warning(this.skipped);
        } else {
            builder.a(SKIPPED).a(this.skipped);
        }
        builder.a(COMMA).a(reportEntry.getElapsedTimeVerbose());
        if (isFailureOrError) {
            builder.failure(FAILURE_MARKER);
        }
        builder.a(IN_MARKER);
        return TestSetStats.concatenateWithTestGroup(builder, (ReportEntry)reportEntry);
    }

    public List<String> getTestResults() {
        ArrayList<String> result = new ArrayList<String>();
        for (WrappedReportEntry testResult : this.reportEntries) {
            if (testResult.isErrorOrFailure()) {
                result.add(testResult.getOutput(this.trimStackTrace));
                continue;
            }
            if (this.plainFormat && testResult.isSkipped()) {
                result.add(testResult.getName() + " skipped");
                continue;
            }
            if (!this.plainFormat || !testResult.isSucceeded()) continue;
            result.add(testResult.getElapsedTimeSummary());
        }
        return result;
    }

    public Collection<WrappedReportEntry> getReportEntries() {
        return this.reportEntries;
    }

    public static String concatenateWithTestGroup(MessageBuilder builder, ReportEntry report) {
        String testClass = report.getNameWithGroup();
        int delimiter = testClass.lastIndexOf(46);
        String pkg = testClass.substring(0, 1 + delimiter);
        String cls = testClass.substring(1 + delimiter);
        return builder.a(pkg).strong(cls).toString();
    }
}

