/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitStatusConsumer
implements StreamConsumer {
    private static final String ADDED_PATTERN = "^A[ M]* (.*)$";
    private static final String MODIFIED_PATTERN = "^ *M[ M]* (.*)$";
    private static final String DELETED_PATTERN = "^ *D * (.*)$";
    private static final String RENAMED_PATTERN = "R (.*) -> (.*)$";
    private RE addedRegexp;
    private RE modifiedRegexp;
    private RE deletedRegexp;
    private RE renamedRegexp;
    private ScmLogger logger;
    private File workingDirectory;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();

    public GitStatusConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
        try {
            this.addedRegexp = new RE(ADDED_PATTERN);
            this.modifiedRegexp = new RE(MODIFIED_PATTERN);
            this.deletedRegexp = new RE(DELETED_PATTERN);
            this.renamedRegexp = new RE(RENAMED_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (StringUtils.isEmpty((String)line)) {
            return;
        }
        ScmFileStatus status = null;
        ArrayList<String> files = new ArrayList<String>();
        if (this.addedRegexp.match(line)) {
            status = ScmFileStatus.ADDED;
            files.add(this.addedRegexp.getParen(1));
        } else if (this.modifiedRegexp.match(line)) {
            status = ScmFileStatus.MODIFIED;
            files.add(this.modifiedRegexp.getParen(1));
        } else if (this.deletedRegexp.match(line)) {
            status = ScmFileStatus.DELETED;
            files.add(this.deletedRegexp.getParen(1));
        } else if (this.renamedRegexp.match(line)) {
            status = ScmFileStatus.RENAMED;
            files.add(StringUtils.trim((String)this.renamedRegexp.getParen(1)));
            files.add(StringUtils.trim((String)this.renamedRegexp.getParen(2)));
            this.logger.debug("RENAMED status for line '" + line + "' files added '" + this.renamedRegexp.getParen(1) + "' '" + this.renamedRegexp.getParen(2));
        }
        if (!files.isEmpty() && status != null) {
            if (this.workingDirectory != null) {
                if (status == ScmFileStatus.RENAMED) {
                    String oldFilePath = (String)files.get(0);
                    String newFilePath = (String)files.get(1);
                    if (new File(this.workingDirectory, oldFilePath).isFile()) {
                        this.logger.debug("file '" + new File(this.workingDirectory, oldFilePath).getAbsolutePath() + "' is a file");
                        return;
                    }
                    this.logger.debug("file '" + new File(this.workingDirectory, oldFilePath).getAbsolutePath() + "' not a file");
                    if (!new File(this.workingDirectory, newFilePath).isFile()) {
                        this.logger.debug("file '" + new File(this.workingDirectory, newFilePath).getAbsolutePath() + "' not a file");
                        return;
                    }
                    this.logger.debug("file '" + new File(this.workingDirectory, newFilePath).getAbsolutePath() + "' is a file");
                } else if (status == ScmFileStatus.DELETED ? new File(this.workingDirectory, (String)files.get(0)).isFile() : !new File(this.workingDirectory, (String)files.get(0)).isFile()) {
                    return;
                }
            }
            for (String file : files) {
                this.changedFiles.add(new ScmFile(file, status));
            }
        }
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

