/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScmResult
implements Serializable {
    private static final long serialVersionUID = 7037918334820621525L;
    private final boolean success;
    private final String providerMessage;
    private final String commandOutput;
    private final String commandLine;
    public static final String PASSWORD_PLACE_HOLDER = "********";
    private Pattern patternForUserColonPasswordAtHost = Pattern.compile("^.*:(.*)@.*$");

    public ScmResult(ScmResult scmResult) {
        this.commandLine = scmResult.commandLine;
        this.providerMessage = scmResult.providerMessage;
        this.commandOutput = this.masked(scmResult.commandOutput);
        this.success = scmResult.success;
    }

    public ScmResult(String commandLine, String providerMessage, String commandOutput, boolean success) {
        this.commandLine = commandLine;
        this.providerMessage = providerMessage;
        this.commandOutput = this.masked(commandOutput);
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getProviderMessage() {
        return this.providerMessage;
    }

    public String getCommandOutput() {
        return this.commandOutput;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    private String masked(String commandOutput) {
        Matcher passwordMatcher;
        if (null != commandOutput && (passwordMatcher = this.patternForUserColonPasswordAtHost.matcher(commandOutput)).find()) {
            String clearPassword = passwordMatcher.group(1);
            commandOutput = commandOutput.replace(clearPassword, PASSWORD_PLACE_HOLDER);
        }
        return commandOutput;
    }
}

