/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ManifestResourceTransformer
implements ResourceTransformer {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private String mainClass;
    private Map manifestEntries;
    private boolean manifestDiscovered;
    private Manifest manifest;

    public boolean canTransformResource(String resource) {
        return MANIFEST_PATH.equalsIgnoreCase(resource);
    }

    public void processResource(String resource, InputStream is, List relocators) throws IOException {
        if (!this.manifestDiscovered) {
            this.manifest = new Manifest(is);
            this.manifestDiscovered = true;
            IOUtil.close((InputStream)is);
        }
    }

    public boolean hasTransformedResource() {
        return true;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes attributes = this.manifest.getMainAttributes();
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.manifestEntries != null) {
            Iterator i = this.manifestEntries.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                attributes.put(new Attributes.Name(key), this.manifestEntries.get(key));
            }
        }
        jos.putNextEntry(new JarEntry(MANIFEST_PATH));
        this.manifest.write(jos);
    }
}

