/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public class BranchMojo
extends AbstractScmMojo {
    private String branch;
    private String message;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            String finalBranch = provider.sanitizeTagName(this.branch);
            this.getLog().info((CharSequence)("Final Branch Name: '" + finalBranch + "'"));
            BranchScmResult result = provider.branch(repository, this.getFileSet(), finalBranch, this.message);
            this.checkResult((ScmResult)result);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run branch command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run branch command : ", (Exception)((Object)e));
        }
    }
}

