/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources.remote;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.resources.remote.ModelInheritanceAssembler;
import org.apache.maven.plugin.resources.remote.RemoteResourcesBundle;
import org.apache.maven.plugin.resources.remote.RemoteResourcesClassLoader;
import org.apache.maven.plugin.resources.remote.Supplement;
import org.apache.maven.plugin.resources.remote.SupplementalDataModel;
import org.apache.maven.plugin.resources.remote.io.xpp3.RemoteResourcesBundleXpp3Reader;
import org.apache.maven.plugin.resources.remote.io.xpp3.SupplementalDataModelXpp3Reader;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractProcessRemoteResourcesMojo
extends AbstractMojo {
    private static final String TEMPLATE_SUFFIX = ".vm";
    @Parameter
    protected List<String> filterDelimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultFilterDelimiters;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/maven-shared-archive-resources")
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}/src/main/appended-resources")
    private File appendedResourcesDirectory;
    @Parameter
    private String[] supplementalModels;
    @Parameter
    private List<String> supplementalModelArtifacts;
    @Parameter(property="resourceBundles", required=true)
    private List<String> resourceBundles;
    @Parameter(property="remoteresources.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true", property="attachToMain")
    private boolean attachToMain;
    @Parameter(defaultValue="true", property="attachToTest")
    private boolean attachToTest;
    @Parameter
    protected Map<String, String> properties = new HashMap<String, String>();
    @Deprecated
    @Parameter(defaultValue="false")
    protected boolean includeProjectProperties = false;
    @Deprecated
    @Parameter(defaultValue="5242880")
    protected int velocityFilterInMemoryThreshold = 0x500000;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="includeScope", defaultValue="runtime")
    protected String includeScope;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter
    protected String[] resolveScopes;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter(property="excludeTransitive", defaultValue="false")
    protected boolean excludeTransitive;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(defaultValue="false")
    private boolean useProjectFiles;
    private Map<String, Model> supplementModels;
    private final ModelInheritanceAssembler inheritanceAssembler = new ModelInheritanceAssembler();
    private VelocityEngine velocity;
    protected final RepositorySystem repoSystem;
    private final MavenFileFilter fileFilter;
    private final ResourceManager locator;
    private final ProjectBuilder projectBuilder;
    private final ArtifactHandlerManager artifactHandlerManager;
    private static final String KEY_PROJECTS = "projects";
    private static final String KEY_PROJECTS_ORGS = "projectsSortedByOrganization";

    protected AbstractProcessRemoteResourcesMojo(RepositorySystem repoSystem, MavenFileFilter fileFilter, ResourceManager locator, ProjectBuilder projectBuilder, ArtifactHandlerManager artifactHandlerManager) {
        this.repoSystem = repoSystem;
        this.fileFilter = fileFilter;
        this.locator = locator;
        this.projectBuilder = projectBuilder;
        this.artifactHandlerManager = artifactHandlerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block13: {
            File sups;
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping remote resources execution.");
                return;
            }
            if (this.encoding == null || this.encoding.isEmpty()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + Charset.defaultCharset() + ", i.e. build is platform dependent!"));
                this.encoding = Charset.defaultCharset().name();
            }
            if (this.resolveScopes == null) {
                this.resolveScopes = new String[]{this.includeScope == null || this.includeScope.isEmpty() ? "test" : this.includeScope};
            }
            if (this.supplementalModels == null && (sups = new File(this.appendedResourcesDirectory, "supplemental-models.xml")).exists()) {
                try {
                    this.supplementalModels = new String[]{sups.toURI().toURL().toString()};
                }
                catch (MalformedURLException e) {
                    this.getLog().debug((CharSequence)("URL issue with supplemental-models.xml: " + e));
                }
            }
            this.configureLocator();
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.validate();
                List<File> resourceBundleArtifacts = this.downloadBundles(this.resourceBundles);
                this.supplementModels = this.loadSupplements(this.supplementalModels);
                ClassLoader classLoader = this.initalizeClassloader(resourceBundleArtifacts);
                Thread.currentThread().setContextClassLoader(classLoader);
                this.velocity = new VelocityEngine();
                this.velocity.setProperty("resource.loaders", (Object)"classpath");
                this.velocity.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
                this.velocity.init();
                VelocityContext context = this.buildVelocityContext();
                this.processResourceBundles(classLoader, context);
                if (!this.outputDirectory.exists()) break block13;
                Resource resource = new Resource();
                resource.setDirectory(this.outputDirectory.getAbsolutePath());
                if (this.attachToMain) {
                    this.project.getResources().add(resource);
                }
                if (this.attachToTest) {
                    this.project.getTestResources().add(resource);
                }
                try {
                    File dotFile = new File(this.project.getBuild().getDirectory(), ".plxarc");
                    FileUtils.mkdir((String)dotFile.getParentFile().getAbsolutePath());
                    FileUtils.fileWrite((String)dotFile.getAbsolutePath(), (String)this.outputDirectory.getName());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating dot file for archiving instructions.", (Exception)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    private void configureLocator() throws MojoExecutionException {
        if (this.supplementalModelArtifacts != null && !this.supplementalModelArtifacts.isEmpty()) {
            List<File> artifacts = this.downloadBundles(this.supplementalModelArtifacts);
            for (File artifact : artifacts) {
                if (artifact.isDirectory()) {
                    this.locator.addSearchPath("file", artifact.getAbsolutePath());
                    continue;
                }
                try {
                    this.locator.addSearchPath("jar", "jar:" + artifact.toURI().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Could not use jar " + artifact.getAbsolutePath(), (Exception)e);
                }
            }
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        if (this.appendedResourcesDirectory != null) {
            this.locator.addSearchPath("file", this.appendedResourcesDirectory.getAbsolutePath());
        }
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
    }

    protected List<MavenProject> getProjects() {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        FilterArtifacts filter = new FilterArtifacts();
        Set<Object> artifacts = new LinkedHashSet<Artifact>(this.getAllDependencies());
        if (this.excludeTransitive) {
            filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.getDirectDependencies(), true));
        }
        filter.addFilter((ArtifactsFilter)new ScopeFilter(this.includeScope, this.excludeScope));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(this.includeGroupIds, this.excludeGroupIds));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(this.includeArtifactIds, this.excludeArtifactIds));
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.getLog().debug((CharSequence)("PROJECTS: " + artifacts));
        for (Artifact artifact : artifacts) {
            MavenProject p;
            if (artifact.isSnapshot()) {
                artifact.setVersion(artifact.getBaseVersion());
            }
            this.getLog().debug((CharSequence)("Building project for " + artifact));
            try {
                ProjectBuildingRequest req = new DefaultProjectBuildingRequest().setValidationLevel(0).setProcessPlugins(false).setRepositorySession(this.mavenSession.getRepositorySession()).setSystemProperties(this.mavenSession.getSystemProperties()).setUserProperties(this.mavenSession.getUserProperties()).setLocalRepository(this.mavenSession.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
                ProjectBuildingResult res = this.projectBuilder.build(artifact, req);
                p = res.getProject();
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((CharSequence)("Invalid project model for artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + "]. It will be ignored by the remote resources Mojo."));
                continue;
            }
            String supplementKey = AbstractProcessRemoteResourcesMojo.generateSupplementMapKey(p.getModel().getGroupId(), p.getModel().getArtifactId());
            if (this.supplementModels.containsKey(supplementKey)) {
                Model mergedModel = this.mergeModels(p.getModel(), this.supplementModels.get(supplementKey));
                MavenProject mergedProject = new MavenProject(mergedModel);
                projects.add(mergedProject);
                mergedProject.setArtifact(artifact);
                mergedProject.setVersion(artifact.getVersion());
                this.getLog().debug((CharSequence)("Adding project with groupId [" + mergedProject.getGroupId() + "] (supplemented)"));
                continue;
            }
            projects.add(p);
            this.getLog().debug((CharSequence)("Adding project with groupId [" + p.getGroupId() + "]"));
        }
        projects.sort(new ProjectComparator());
        return projects;
    }

    protected abstract Set<Artifact> getAllDependencies();

    protected abstract Set<Artifact> getDirectDependencies();

    protected Map<Organization, List<MavenProject>> getProjectsSortedByOrganization(List<MavenProject> projects) {
        TreeMap<Organization, List<MavenProject>> organizations = new TreeMap<Organization, List<MavenProject>>(new OrganizationComparator());
        ArrayList<MavenProject> unknownOrganization = new ArrayList<MavenProject>();
        for (MavenProject p : projects) {
            if (p.getOrganization() != null && StringUtils.isNotEmpty((String)p.getOrganization().getName())) {
                ArrayList<MavenProject> sortedProjects = (ArrayList<MavenProject>)organizations.get(p.getOrganization());
                if (sortedProjects == null) {
                    sortedProjects = new ArrayList<MavenProject>();
                }
                sortedProjects.add(p);
                organizations.put(p.getOrganization(), sortedProjects);
                continue;
            }
            unknownOrganization.add(p);
        }
        if (!unknownOrganization.isEmpty()) {
            Organization unknownOrg = new Organization();
            unknownOrg.setName("an unknown organization");
            organizations.put(unknownOrg, unknownOrganization);
        }
        return organizations;
    }

    protected boolean copyResourceIfExists(File outputFile, String bundleResourceName, VelocityContext context, String encoding) throws IOException, MojoExecutionException {
        for (Resource resource : this.project.getResources()) {
            block26: {
                File resourceDirectory = new File(resource.getDirectory());
                if (!resourceDirectory.exists()) continue;
                File source = new File(resourceDirectory, bundleResourceName);
                File templateSource = new File(resourceDirectory, bundleResourceName + TEMPLATE_SUFFIX);
                if (!source.exists() && templateSource.exists()) {
                    source = templateSource;
                }
                if (!source.exists() || source.equals(outputFile)) continue;
                if (source == templateSource) {
                    this.getLog().debug((CharSequence)("Use project resource '" + source + "' as resource with Velocity"));
                    try (CachingOutputStream os = new CachingOutputStream(outputFile);
                         Writer writer = this.getWriter(encoding, (OutputStream)os);
                         Reader reader = this.getReader(encoding, source);){
                        this.velocity.evaluate((Context)context, writer, "", reader);
                        break block26;
                    }
                    catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException e) {
                        throw new MojoExecutionException("Error rendering velocity resource: " + source, (Exception)e);
                    }
                }
                if (resource.isFiltering()) {
                    this.getLog().debug((CharSequence)("Use project resource '" + source + "' as resource with filtering"));
                    MavenFileFilterRequest req = this.setupRequest(resource, source, outputFile);
                    try {
                        this.fileFilter.copyFile(req);
                    }
                    catch (MavenFilteringException e) {
                        throw new MojoExecutionException("Error filtering resource: " + source, (Exception)((Object)e));
                    }
                } else {
                    this.getLog().debug((CharSequence)("Use project resource '" + source + "' as resource"));
                    FilteringUtils.copyFile((File)source, (File)outputFile, null, null);
                }
            }
            resource.addExclude(bundleResourceName);
            return true;
        }
        return false;
    }

    private boolean copyProjectRootIfExists(File outputFile, String bundleResourceName) throws IOException {
        if (!this.useProjectFiles) {
            return false;
        }
        File source = new File(this.project.getBasedir(), bundleResourceName);
        if (source.exists()) {
            this.getLog().debug((CharSequence)("Use project file '" + source + "' as resource"));
            FilteringUtils.copyFile((File)source, (File)outputFile, null, null);
            return true;
        }
        return false;
    }

    private Reader getReader(String readerEncoding, File file) throws IOException {
        return Files.newBufferedReader(file.toPath(), Charset.forName(readerEncoding != null ? readerEncoding : this.encoding));
    }

    private Writer getWriter(String writerEncoding, OutputStream outputStream) throws IOException {
        return new OutputStreamWriter(outputStream, writerEncoding != null ? writerEncoding : this.encoding);
    }

    private MavenFileFilterRequest setupRequest(Resource resource, File source, File file) {
        MavenFileFilterRequest req = new MavenFileFilterRequest();
        req.setFrom(source);
        req.setTo(file);
        req.setFiltering(resource.isFiltering());
        req.setMavenProject(this.project);
        req.setMavenSession(this.mavenSession);
        req.setInjectProjectBuildFilters(true);
        req.setEncoding(this.encoding);
        if (this.filterDelimiters != null && !this.filterDelimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (this.useDefaultFilterDelimiters) {
                delims.addAll(req.getDelimiters());
            }
            for (String delim : this.filterDelimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            req.setDelimiters(delims);
        }
        return req;
    }

    protected void validate() throws MojoExecutionException {
        int bundleCount = 1;
        for (String artifactDescriptor : this.resourceBundles) {
            String[] s = StringUtils.split((String)artifactDescriptor, (String)":");
            if (s.length < 3 || s.length > 5) {
                String position = bundleCount == 1 ? "1st" : (bundleCount == 2 ? "2nd" : (bundleCount == 3 ? "3rd" : bundleCount + "th"));
                throw new MojoExecutionException("The " + position + " resource bundle configured must specify a groupId, artifactId,  version and, optionally, type and classifier for a remote resource bundle. Must be of the form <resourceBundle>groupId:artifactId:version</resourceBundle>, <resourceBundle>groupId:artifactId:version:type</resourceBundle> or <resourceBundle>groupId:artifactId:version:type:classifier</resourceBundle>");
            }
            ++bundleCount;
        }
    }

    protected VelocityContext buildVelocityContext() {
        HashMap<String, String> contextProperties = new HashMap<String, String>(this.properties);
        if (this.includeProjectProperties) {
            Properties projectProperties = this.project.getProperties();
            for (String key : projectProperties.stringPropertyNames()) {
                contextProperties.put(key, projectProperties.getProperty(key));
            }
        }
        VelocityContext context = new VelocityContext(contextProperties){

            public Object internalGet(String key) {
                Object result = super.internalGet(key);
                if (result == null && key != null && key.startsWith(AbstractProcessRemoteResourcesMojo.KEY_PROJECTS) && this.containsKey(key)) {
                    List<MavenProject> projects = AbstractProcessRemoteResourcesMojo.this.getProjects();
                    this.put(AbstractProcessRemoteResourcesMojo.KEY_PROJECTS, projects);
                    this.put(AbstractProcessRemoteResourcesMojo.KEY_PROJECTS_ORGS, AbstractProcessRemoteResourcesMojo.this.getProjectsSortedByOrganization(projects));
                    return super.internalGet(key);
                }
                return result;
            }
        };
        context.put(KEY_PROJECTS, null);
        context.put(KEY_PROJECTS_ORGS, null);
        String inceptionYear = this.project.getInceptionYear();
        String year = MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).orElseGet(Instant::now).atZone(ZoneId.of("UTC+10")).format(DateTimeFormatter.ofPattern("yyyy"));
        if (inceptionYear == null || inceptionYear.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("inceptionYear not specified, defaulting to " + year));
            }
            inceptionYear = year;
        }
        context.put("project", (Object)this.project);
        context.put("presentYear", (Object)year);
        context.put("locator", (Object)this.locator);
        if (inceptionYear.equals(year)) {
            context.put("projectTimespan", (Object)year);
        } else {
            context.put("projectTimespan", (Object)(inceptionYear + "-" + year));
        }
        return context;
    }

    private List<File> downloadBundles(List<String> bundles) throws MojoExecutionException {
        ArrayList<File> bundleArtifacts = new ArrayList<File>();
        for (String artifactDescriptor : bundles) {
            this.getLog().info((CharSequence)("Preparing remote bundle " + artifactDescriptor));
            String[] s = artifactDescriptor.split(":");
            File artifactFile = null;
            if (this.mavenSession != null) {
                List list = this.mavenSession.getProjects();
                for (MavenProject p : list) {
                    if (!s[0].equals(p.getGroupId()) || !s[1].equals(p.getArtifactId()) || !s[2].equals(p.getVersion())) continue;
                    if (s.length >= 4 && "test-jar".equals(s[3])) {
                        artifactFile = new File(p.getBuild().getTestOutputDirectory());
                        continue;
                    }
                    artifactFile = new File(p.getBuild().getOutputDirectory());
                }
            }
            if (artifactFile == null || !artifactFile.exists()) {
                String g = s[0];
                String a = s[1];
                String v = s[2];
                String type = s.length >= 4 ? s[3] : "jar";
                ArtifactType artifactType = RepositoryUtils.newArtifactType((String)type, (ArtifactHandler)this.artifactHandlerManager.getArtifactHandler(type));
                String classifier = s.length == 5 ? s[4] : artifactType.getClassifier();
                DefaultArtifact artifact = new DefaultArtifact(g, a, classifier, artifactType.getExtension(), v, artifactType);
                try {
                    ArtifactRequest request = new ArtifactRequest((org.eclipse.aether.artifact.Artifact)artifact, this.project.getRemoteProjectRepositories(), "remote-resources");
                    ArtifactResult result = this.repoSystem.resolveArtifact(this.mavenSession.getRepositorySession(), request);
                    artifactFile = result.getArtifact().getFile();
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException("Error processing remote resources", (Exception)((Object)e));
                }
            }
            bundleArtifacts.add(artifactFile);
        }
        return bundleArtifacts;
    }

    private ClassLoader initalizeClassloader(List<File> artifacts) throws MojoExecutionException {
        RemoteResourcesClassLoader cl = new RemoteResourcesClassLoader(null);
        try {
            for (File artifact : artifacts) {
                cl.addURL(artifact.toURI().toURL());
            }
            return cl;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to configure resources classloader: " + e.getMessage(), (Exception)e);
        }
    }

    protected void processResourceBundles(ClassLoader classLoader, VelocityContext context) throws MojoExecutionException {
        ArrayList<AbstractMap.SimpleEntry<String, RemoteResourcesBundle>> remoteResources = new ArrayList<AbstractMap.SimpleEntry<String, RemoteResourcesBundle>>();
        int bundleCount = 0;
        int resourceCount = 0;
        try {
            RemoteResourcesBundleXpp3Reader bundleReader = new RemoteResourcesBundleXpp3Reader();
            Enumeration<URL> e = classLoader.getResources("META-INF/maven/remote-resources.xml");
            while (e.hasMoreElements()) {
                RemoteResourcesBundle bundle;
                URL uRL = e.nextElement();
                this.getLog().debug((CharSequence)("processResourceBundle on bundle#" + ++bundleCount + " " + uRL));
                try (InputStream in = uRL.openStream();){
                    bundle = bundleReader.read(in);
                }
                this.verifyRequiredProperties(bundle, uRL);
                int n = 0;
                for (String bundleResource : bundle.getRemoteResources()) {
                    ++resourceCount;
                    this.getLog().debug((CharSequence)("bundle#" + bundleCount + " resource#" + ++n + " " + bundleResource));
                    remoteResources.add(new AbstractMap.SimpleEntry<String, RemoteResourcesBundle>(bundleResource, bundle));
                }
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error finding remote resources manifests", (Exception)ioe);
        }
        catch (XmlPullParserException xppe) {
            throw new MojoExecutionException("Error parsing remote resource bundle descriptor.", (Exception)((Object)xppe));
        }
        this.getLog().info((CharSequence)("Copying " + resourceCount + " resource" + (resourceCount > 1 ? "s" : "") + " from " + bundleCount + " bundle" + (bundleCount > 1 ? "s" : "") + "."));
        String velocityResource = null;
        try {
            for (Map.Entry entry : remoteResources) {
                File outputFile;
                String projectResource;
                RemoteResourcesBundle bundle;
                block58: {
                    String bundleResource = (String)entry.getKey();
                    bundle = (RemoteResourcesBundle)entry.getValue();
                    projectResource = bundleResource;
                    boolean doVelocity = false;
                    if (projectResource.endsWith(TEMPLATE_SUFFIX)) {
                        projectResource = projectResource.substring(0, projectResource.length() - 3);
                        velocityResource = bundleResource;
                        doVelocity = true;
                    }
                    outputFile = new File(this.outputDirectory, projectResource);
                    FileUtils.mkdir((String)outputFile.getParentFile().getAbsolutePath());
                    if (this.copyResourceIfExists(outputFile, projectResource, context, bundle.getSourceEncoding()) || this.copyProjectRootIfExists(outputFile, projectResource)) continue;
                    if (doVelocity) {
                        String bundleEncoding = bundle.getSourceEncoding();
                        if (bundleEncoding == null) {
                            bundleEncoding = this.encoding;
                        }
                        try (CachingOutputStream os = new CachingOutputStream(outputFile);
                             Writer writer = this.getWriter(bundleEncoding, (OutputStream)os);){
                            this.velocity.mergeTemplate(bundleResource, bundleEncoding, (Context)context, writer);
                            break block58;
                        }
                    }
                    URL bundleResourceUrl = classLoader.getResource(bundleResource);
                    if (bundleResourceUrl != null) {
                        FileUtils.copyURLToFile((URL)bundleResourceUrl, (File)outputFile);
                    }
                }
                File appendedResourceFile = new File(this.appendedResourcesDirectory, projectResource);
                File appendedVmResourceFile = new File(this.appendedResourcesDirectory, projectResource + TEMPLATE_SUFFIX);
                if (appendedResourceFile.exists()) {
                    this.getLog().info((CharSequence)("Copying appended resource: " + projectResource));
                    InputStream in = Files.newInputStream(appendedResourceFile.toPath(), new OpenOption[0]);
                    try {
                        FileOutputStream out = new FileOutputStream(outputFile, true);
                        try {
                            IOUtil.copy((InputStream)in, (OutputStream)out);
                            continue;
                        }
                        finally {
                            ((OutputStream)out).close();
                            continue;
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        continue;
                    }
                }
                if (!appendedVmResourceFile.exists()) continue;
                this.getLog().info((CharSequence)("Filtering appended resource: " + projectResource + TEMPLATE_SUFFIX));
                try (CachingOutputStream os = new CachingOutputStream(outputFile);){
                    Reader reader = this.getReader(bundle.getSourceEncoding(), appendedVmResourceFile);
                    try {
                        Writer writer = this.getWriter(bundle.getSourceEncoding(), (OutputStream)os);
                        try {
                            Velocity.init();
                            Velocity.evaluate((Context)context, (Writer)writer, (String)"remote-resources", (Reader)reader);
                        }
                        finally {
                            if (writer == null) continue;
                            writer.close();
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading remote resource", (Exception)ioe);
        }
        catch (VelocityException e) {
            throw new MojoExecutionException("Error rendering Velocity resource '" + velocityResource + "'", (Exception)((Object)e));
        }
    }

    private void verifyRequiredProperties(RemoteResourcesBundle bundle, URL url) throws MojoExecutionException {
        if (bundle.getRequiredProjectProperties() == null || bundle.getRequiredProjectProperties().isEmpty()) {
            return;
        }
        for (String requiredProperty : bundle.getRequiredProjectProperties()) {
            if (this.project.getProperties().containsKey(requiredProperty)) continue;
            throw new MojoExecutionException("Required project property: '" + requiredProperty + "' is not present for bundle: " + url);
        }
    }

    protected Model getSupplement(Xpp3Dom supplementModelXml) throws MojoExecutionException {
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = modelReader.read((Reader)new StringReader(supplementModelXml.toString()));
            String groupId = model.getGroupId();
            String artifactId = model.getArtifactId();
            if (groupId == null || groupId.trim().isEmpty()) {
                throw new MojoExecutionException("Supplemental project XML requires that a <groupId> element be present.");
            }
            if (artifactId == null || artifactId.trim().isEmpty()) {
                throw new MojoExecutionException("Supplemental project XML requires that a <artifactId> element be present.");
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to read supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            this.getLog().warn((CharSequence)("Unable to parse supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        return model;
    }

    protected Model mergeModels(Model parent, Model child) {
        this.inheritanceAssembler.assembleModelInheritance(child, parent);
        return child;
    }

    private static String generateSupplementMapKey(String groupId, String artifactId) {
        return groupId.trim() + ":" + artifactId.trim();
    }

    private Map<String, Model> loadSupplements(String[] models) throws MojoExecutionException {
        if (models == null) {
            this.getLog().debug((CharSequence)"Supplemental data models won't be loaded. No models specified.");
            return Collections.emptyMap();
        }
        ArrayList<Supplement> supplements = new ArrayList<Supplement>();
        for (String set : models) {
            this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
            try {
                File f = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                if (null == f || !f.exists()) {
                    throw new MojoExecutionException("Cold not resolve " + set);
                }
                if (!f.canRead()) {
                    throw new MojoExecutionException("Supplemental data models won't be loaded. File " + f.getAbsolutePath() + " cannot be read, check permissions on the file.");
                }
                this.getLog().debug((CharSequence)("Loading supplemental models from " + f.getAbsolutePath()));
                SupplementalDataModelXpp3Reader reader = new SupplementalDataModelXpp3Reader();
                SupplementalDataModel supplementalModel = reader.read(new FileReader(f));
                supplements.addAll(supplementalModel.getSupplement());
            }
            catch (Exception e) {
                String msg = "Error loading supplemental data models: " + e.getMessage();
                this.getLog().error((CharSequence)msg, (Throwable)e);
                throw new MojoExecutionException(msg, e);
            }
        }
        this.getLog().debug((CharSequence)"Loading supplements complete.");
        HashMap<String, Model> supplementMap = new HashMap<String, Model>();
        for (Supplement sd : supplements) {
            Xpp3Dom dom = (Xpp3Dom)sd.getProject();
            Model m = this.getSupplement(dom);
            supplementMap.put(AbstractProcessRemoteResourcesMojo.generateSupplementMapKey(m.getGroupId(), m.getArtifactId()), m);
        }
        return supplementMap;
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    static class ProjectComparator
    implements Comparator<MavenProject> {
        ProjectComparator() {
        }

        @Override
        public int compare(MavenProject p1, MavenProject p2) {
            return p1.getArtifact().compareTo((Object)p2.getArtifact());
        }
    }

    static class OrganizationComparator
    implements Comparator<Organization> {
        OrganizationComparator() {
        }

        @Override
        public int compare(Organization org1, Organization org2) {
            int i = this.compareStrings(org1.getName(), org2.getName());
            if (i == 0) {
                i = this.compareStrings(org1.getUrl(), org2.getUrl());
            }
            return i;
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

