/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.projecthelp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class EffectivePomPlugin
extends AbstractMojo {
    private Model pom;
    private String output;

    public void execute() throws MojoExecutionException {
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, this.pom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        if (this.output != null && this.output.trim().length() > 0) {
            OutputStreamWriter fWriter = null;
            try {
                File outFile = new File(this.output).getAbsoluteFile();
                File dir = outFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                this.getLog().info((CharSequence)("Writing effective-POM to: " + outFile));
                fWriter = new FileWriter(outFile);
                fWriter.write(sWriter.toString());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-POM to output: " + this.output, (Exception)e);
            }
            finally {
                if (fWriter != null) {
                    try {
                        fWriter.close();
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("Cannot close FileWriter to output location: " + this.output), (Throwable)e);
                    }
                }
            }
        }
        StringBuffer message = new StringBuffer();
        message.append("\nEffective POM, after all profiles are factored in:\n\n");
        message.append(sWriter.toString());
        message.append("\n\n");
        this.getLog().info((CharSequence)message);
    }

    protected final String getOutput() {
        return this.output;
    }

    protected final void setOutput(String output) {
        this.output = output;
    }

    protected final Model getPom() {
        return this.pom;
    }

    protected final void setPom(Model pom) {
        this.pom = pom;
    }
}

