/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.CpdReportGenerator;
import org.apache.maven.plugins.pmd.exec.CpdExecutor;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.plugins.pmd.exec.CpdResult;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.Toolchain;

@Mojo(name="cpd", threadSafe=true)
public class CpdReport
extends AbstractPmdReport {
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumTokens", defaultValue="100")
    private int minimumTokens;
    @Parameter(property="cpd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cpd.ignoreLiterals", defaultValue="false")
    private boolean ignoreLiterals;
    @Parameter(property="cpd.ignoreIdentifiers", defaultValue="false")
    private boolean ignoreIdentifiers;
    @Parameter(property="cpd.ignoreAnnotations", defaultValue="false")
    private boolean ignoreAnnotations;
    private CpdResult cpdResult;

    public String getName(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.name");
    }

    public String getDescription(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.description");
    }

    public void executeReport(Locale locale) throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.generateMavenSiteReport(locale);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    @Override
    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping CPD execution");
            return false;
        }
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executeCpd();
                if (this.skipEmptyReport && !(result = this.cpdResult.hasDuplications())) {
                    this.getLog().debug((CharSequence)"Skipping report since skipEmptyReport is true and there are no CPD issues.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void executeCpd() throws MavenReportException {
        if (this.cpdResult != null) {
            this.getLog().debug((CharSequence)"CPD has already been run - skipping redundant execution.");
            return;
        }
        Properties languageProperties = new Properties();
        if (this.ignoreLiterals) {
            languageProperties.setProperty("ignore_literals", "true");
        }
        if (this.ignoreIdentifiers) {
            languageProperties.setProperty("ignore_identifiers", "true");
        }
        if (this.ignoreAnnotations) {
            languageProperties.setProperty("ignore_annotations", "true");
        }
        try {
            this.filesToProcess = this.getFilesToProcess();
            CpdRequest request = new CpdRequest();
            request.setMinimumTokens(this.minimumTokens);
            request.setLanguage(this.language);
            request.setLanguageProperties(languageProperties);
            request.setSourceEncoding(this.getInputEncoding());
            request.addFiles(this.filesToProcess.keySet());
            request.setShowPmdLog(this.showPmdLog);
            request.setLogLevel(this.determineCurrentRootLogLevel());
            request.setExcludeFromFailureFile(this.excludeFromFailureFile);
            request.setTargetDirectory(this.targetDirectory.getAbsolutePath());
            request.setOutputEncoding(this.getOutputEncoding());
            request.setFormat(this.format);
            request.setIncludeXmlInSite(this.includeXmlInSite);
            request.setReportOutputDirectory(this.getReportOutputDirectory().getAbsolutePath());
            Toolchain tc = this.getToolchain();
            if (tc != null) {
                this.getLog().info((CharSequence)("Toolchain in maven-pmd-plugin: " + tc));
                String javaExecutable = tc.findTool("java");
                request.setJavaExecutable(javaExecutable);
            }
            this.getLog().info((CharSequence)("PMD version: " + AbstractPmdReport.getPmdVersion()));
            this.cpdResult = CpdExecutor.execute(request);
        }
        catch (UnsupportedEncodingException e) {
            throw new MavenReportException("Encoding '" + this.getInputEncoding() + "' is not supported.", (Exception)e);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    private void generateMavenSiteReport(Locale locale) {
        CpdReportGenerator gen = new CpdReportGenerator(this.getSink(), this.filesToProcess, CpdReport.getBundle(locale), this.isAggregator());
        gen.generate(this.cpdResult.getDuplications());
    }

    public String getOutputName() {
        return "cpd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cpd-report", locale, CpdReport.class.getClassLoader());
    }

    @Deprecated
    public CPDRenderer createRenderer() throws MavenReportException {
        return CpdExecutor.createRenderer(this.format, this.getOutputEncoding());
    }
}

