/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jarsigner.AbstractJarsignerMojo;
import org.apache.maven.plugins.jarsigner.TsaSelector;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;

@Mojo(name="sign", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class JarsignerSignMojo
extends AbstractJarsignerMojo {
    @Parameter(property="jarsigner.keypass")
    private String keypass;
    @Parameter(property="jarsigner.sigfile")
    private String sigfile;
    @Parameter(property="jarsigner.removeExistingSignatures", defaultValue="false")
    private boolean removeExistingSignatures;
    @Parameter(property="jarsigner.tsa")
    private String[] tsa;
    @Parameter(property="jarsigner.tsacert")
    private String[] tsacert;
    @Parameter(property="jarsigner.tsapolicyid")
    private String[] tsapolicyid;
    @Parameter(property="jarsigner.tsadigestalg")
    private String tsadigestalg;
    @Parameter(property="jarsigner.certchain", required=false)
    private File certchain;
    @Parameter(property="jarsigner.maxTries", defaultValue="1")
    private int maxTries;
    @Parameter(property="jarsigner.maxRetryDelaySeconds", defaultValue="0")
    private int maxRetryDelaySeconds;
    @Parameter(property="jarsigner.threadCount", defaultValue="1")
    private int threadCount;
    private WaitStrategy waitStrategy = this::defaultWaitStrategy;
    private TsaSelector tsaSelector;
    private static final int MAX_WAIT_EXPONENT_ATTEMPT = 20;

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo;
        String string = commandLineInfo = commandLine != null ? commandLine.toString() : null;
        if (commandLineInfo != null) {
            commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
        }
        return commandLineInfo;
    }

    @Override
    protected void preProcessArchive(File archive) throws MojoExecutionException {
        if (this.removeExistingSignatures) {
            try {
                JarSignerUtil.unsignArchive((File)archive);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to unsign archive " + archive + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    @Override
    protected void validateParameters() throws MojoExecutionException {
        super.validateParameters();
        if (this.maxTries < 1) {
            this.getLog().warn((CharSequence)this.getMessage("invalidMaxTries", this.maxTries));
            this.maxTries = 1;
        }
        if (this.maxRetryDelaySeconds < 0) {
            this.getLog().warn((CharSequence)this.getMessage("invalidMaxRetryDelaySeconds", this.maxRetryDelaySeconds));
            this.maxRetryDelaySeconds = 0;
        }
        if (this.threadCount < 1) {
            this.getLog().warn((CharSequence)this.getMessage("invalidThreadCount", this.threadCount));
            this.threadCount = 1;
        }
        if (this.tsa.length > 0 && this.tsacert.length > 0) {
            this.getLog().warn((CharSequence)this.getMessage("warnUsageTsaAndTsacertSimultaneous", new Object[0]));
        }
        if (this.tsapolicyid.length > this.tsa.length || this.tsapolicyid.length > this.tsacert.length) {
            this.getLog().warn((CharSequence)this.getMessage("warnUsageTsapolicyidTooMany", this.tsapolicyid.length, this.tsa.length, this.tsacert.length));
        }
        if (this.tsa.length > 1 && this.maxTries == 1) {
            this.getLog().warn((CharSequence)this.getMessage("warnUsageMultiTsaWithoutRetry", this.tsa.length));
        }
        if (this.tsacert.length > 1 && this.maxTries == 1) {
            this.getLog().warn((CharSequence)this.getMessage("warnUsageMultiTsacertWithoutRetry", this.tsacert.length));
        }
        this.tsaSelector = new TsaSelector(this.tsa, this.tsacert, this.tsapolicyid, this.tsadigestalg);
    }

    @Override
    protected JarSignerRequest createRequest(File archive) throws MojoExecutionException {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setSigfile(this.sigfile);
        this.updateJarSignerRequestWithTsa(request, this.tsaSelector.getServer());
        request.setCertchain(this.certchain);
        request.setKeypass(this.decrypt(this.keypass));
        return request;
    }

    private void updateJarSignerRequestWithTsa(JarSignerSignRequest request, TsaSelector.TsaServer tsaServer) {
        request.setTsaLocation(tsaServer.getTsaUrl());
        request.setTsaAlias(tsaServer.getTsaAlias());
        request.setTsapolicyid(tsaServer.getTsaPolicyId());
        request.setTsadigestalg(tsaServer.getTsaDigestAlt());
    }

    @Override
    protected void processArchives(List<File> archives) throws MojoExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(this.threadCount);
        List futures = archives.stream().map(file -> executor.submit(() -> {
            this.processArchive((File)file);
            return null;
        })).collect(Collectors.toList());
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Thread interrupted while waiting for jarsigner to complete", (Exception)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MojoExecutionException) {
                throw (MojoExecutionException)e.getCause();
            }
            throw new MojoExecutionException("Error processing archives", (Exception)e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    protected void executeJarSigner(JarSigner jarSigner, JarSignerRequest request) throws JavaToolException, MojoExecutionException {
        for (int attempt = 0; attempt < this.maxTries; ++attempt) {
            JavaToolResult result = jarSigner.execute((JavaToolRequest)request);
            int resultCode = result.getExitCode();
            if (resultCode == 0) {
                return;
            }
            this.tsaSelector.registerFailure();
            if (attempt >= this.maxTries - 1) {
                throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(result.getCommandline()), resultCode));
            }
            this.waitStrategy.waitAfterFailure(attempt, Duration.ofSeconds(this.maxRetryDelaySeconds));
            this.updateJarSignerRequestWithTsa((JarSignerSignRequest)request, this.tsaSelector.getServer());
        }
    }

    void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    private void defaultWaitStrategy(int attempt, Duration maxRetryDelay) throws MojoExecutionException {
        this.waitAfterFailure(attempt, maxRetryDelay, Thread::sleep);
    }

    void waitAfterFailure(int attempt, Duration maxRetryDelay, Sleeper sleeper) throws MojoExecutionException {
        int exponentAttempt = Math.min(attempt, 20);
        long delayMillis = (long)((double)Duration.ofSeconds(1L).toMillis() * Math.pow(2.0, exponentAttempt));
        if ((delayMillis = Math.min(delayMillis, maxRetryDelay.toMillis())) > 0L) {
            this.getLog().info((CharSequence)("Sleeping after failed attempt for " + delayMillis / 1000L + " seconds..."));
            try {
                sleeper.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MojoExecutionException("Thread interrupted while waiting after failure", (Exception)e);
            }
        }
    }

    @FunctionalInterface
    static interface WaitStrategy {
        public void waitAfterFailure(int var1, Duration var2) throws MojoExecutionException;
    }

    @FunctionalInterface
    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }
}

