/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugins.invoker.AbstractInvokerMojo;
import org.apache.maven.plugins.invoker.InvokerToolchain;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

class SelectorUtils {
    SelectorUtils() {
    }

    static void parseList(String list, Collection<String> includes, Collection<String> excludes) {
        String[] tokens;
        for (String token1 : tokens = list != null ? StringUtils.split((String)list, (String)",") : new String[]{}) {
            String token = token1.trim();
            if (token.startsWith("!")) {
                excludes.add(token.substring(1));
                continue;
            }
            includes.add(token);
        }
    }

    static boolean isOsFamily(String osSpec) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        SelectorUtils.parseList(osSpec, includes, excludes);
        return SelectorUtils.isOsFamily(includes, true) && !SelectorUtils.isOsFamily(excludes, false);
    }

    static boolean isOsFamily(List<String> families, boolean defaultMatch) {
        if (families != null && !families.isEmpty()) {
            for (String family : families) {
                if (!Os.isFamily((String)family)) continue;
                return true;
            }
            return false;
        }
        return defaultMatch;
    }

    static String getMavenVersion() {
        try {
            Properties properties = new Properties();
            properties.load(MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties"));
            return StringUtils.trim((String)properties.getProperty("version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getMavenVersion(File mavenHome) throws IOException {
        File mavenLib = new File(mavenHome, "lib");
        File[] jarFiles = mavenLib.listFiles((dir, name) -> name.endsWith(".jar"));
        if (jarFiles == null) {
            throw new IllegalArgumentException("Invalid Maven home installation directory: " + mavenHome);
        }
        File[] fileArray = jarFiles;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                URL url = new URL("jar:" + file.toURI().toURL().toExternalForm() + "!/META-INF/maven/org.apache.maven/maven-core/pom.properties");
                try (InputStream in = url.openStream();){
                    Properties properties = new Properties();
                    properties.load(in);
                    String version = StringUtils.trim((String)properties.getProperty("version"));
                    if (version != null) {
                        String string = version;
                        return string;
                    }
                }
            }
            catch (FileNotFoundException | MalformedURLException iOException) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    static boolean isMavenVersion(String mavenSpec) {
        return SelectorUtils.isMavenVersion(mavenSpec, SelectorUtils.getMavenVersion());
    }

    static boolean isMavenVersion(String mavenSpec, String actualVersion) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        SelectorUtils.parseList(mavenSpec, includes, excludes);
        List<Integer> mavenVersionList = SelectorUtils.parseVersion(actualVersion);
        return SelectorUtils.isJreVersion(mavenVersionList, includes, true) && !SelectorUtils.isJreVersion(mavenVersionList, excludes, false);
    }

    static String getJreVersion() {
        return System.getProperty("java.version", "");
    }

    static String getJreVersion(File javaHome) {
        return null;
    }

    static boolean isJreVersion(String jreSpec) {
        return SelectorUtils.isJreVersion(jreSpec, SelectorUtils.getJreVersion());
    }

    static boolean isJreVersion(String jreSpec, String actualJreVersion) {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        SelectorUtils.parseList(jreSpec, includes, excludes);
        List<Integer> jreVersion = SelectorUtils.parseVersion(actualJreVersion);
        return SelectorUtils.isJreVersion(jreVersion, includes, true) && !SelectorUtils.isJreVersion(jreVersion, excludes, false);
    }

    static boolean isJreVersion(List<Integer> jreVersion, List<String> versionPatterns, boolean defaultMatch) {
        if (versionPatterns != null && !versionPatterns.isEmpty()) {
            for (String versionPattern : versionPatterns) {
                if (!SelectorUtils.isJreVersion(jreVersion, versionPattern)) continue;
                return true;
            }
            return false;
        }
        return defaultMatch;
    }

    static boolean isJreVersion(List<Integer> jreVersion, String versionPattern) {
        List<Integer> checkVersion = SelectorUtils.parseVersion(versionPattern);
        if (versionPattern.endsWith("+")) {
            return SelectorUtils.compareVersions(jreVersion, checkVersion) >= 0;
        }
        if (versionPattern.endsWith("-")) {
            return SelectorUtils.compareVersions(jreVersion, checkVersion) < 0;
        }
        return checkVersion.size() <= jreVersion.size() && checkVersion.equals(jreVersion.subList(0, checkVersion.size()));
    }

    static List<Integer> parseVersion(String version) {
        version = version.replaceAll("[^0-9]", ".");
        String[] tokens = StringUtils.split((String)version, (String)".");
        List<Integer> numbers = Arrays.stream(tokens).map(Integer::valueOf).collect(Collectors.toList());
        return numbers;
    }

    static int compareVersions(List<Integer> version1, List<Integer> version2) {
        Integer num2;
        Integer num1;
        int rel;
        Iterator<Integer> it1 = version1.iterator();
        Iterator<Integer> it2 = version2.iterator();
        do {
            if (!it1.hasNext()) {
                return it2.hasNext() ? -1 : 0;
            }
            if (it2.hasNext()) continue;
            return it1.hasNext() ? 1 : 0;
        } while ((rel = (num1 = it1.next()).compareTo(num2 = it2.next())) == 0);
        return rel;
    }

    static boolean isToolchain(AbstractInvokerMojo.ToolchainPrivateManager toolchainPrivateManager, Collection<InvokerToolchain> invokerToolchains) {
        for (InvokerToolchain invokerToolchain : invokerToolchains) {
            boolean found = false;
            try {
                for (ToolchainPrivate tc : toolchainPrivateManager.getToolchainPrivates(invokerToolchain.getType())) {
                    if (!invokerToolchain.getType().equals(tc.getType()) || !tc.matchesRequirements(invokerToolchain.getProvides())) continue;
                    found = true;
                }
            }
            catch (MisconfiguredToolchainException e) {
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

