/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.codehaus.plexus.util.FileUtils;

public class EclipseCleanMojo
extends AbstractMojo {
    private static final String FILE_DOT_WTPMODULES = ".wtpmodules";
    private static final String FILE_DOT_CLASSPATH = ".classpath";
    private static final String FILE_DOT_PROJECT = ".project";
    private static final String DIR_DOT_SETTINGS = ".settings";
    private static final String FILE_DOT_COMPONENT = ".settings/.component";
    private static final String FILE_DOT_COMPONENT_15 = ".settings/org.eclipse.wst.common.component";
    private static final String FILE_FACET_CORE_XML = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    private static final String FILE_ECLIPSE_JDT_CORE_PREFS = ".settings/org.eclipse.jdt.core.prefs";
    private String packaging;
    private File basedir;
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        this.delete(new File(this.basedir, FILE_DOT_PROJECT));
        this.delete(new File(this.basedir, FILE_DOT_CLASSPATH));
        this.delete(new File(this.basedir, FILE_DOT_WTPMODULES));
        this.delete(new File(this.basedir, FILE_DOT_COMPONENT));
        this.delete(new File(this.basedir, FILE_DOT_COMPONENT_15));
        this.delete(new File(this.basedir, FILE_FACET_CORE_XML));
        this.delete(new File(this.basedir, FILE_ECLIPSE_JDT_CORE_PREFS));
        File settingsDir = new File(this.basedir, DIR_DOT_SETTINGS);
        if (settingsDir.exists() && settingsDir.isDirectory() && settingsDir.list().length == 0) {
            this.delete(settingsDir);
        }
        this.cleanExtras();
    }

    protected void cleanExtras() throws MojoExecutionException {
    }

    protected void delete(File f) throws MojoExecutionException {
        if (f.isDirectory()) {
            this.getLog().info((CharSequence)Messages.getString("EclipseCleanMojo.deletingDirectory", f.getName()));
        } else {
            this.getLog().info((CharSequence)Messages.getString("EclipseCleanMojo.deletingFile", f.getName()));
        }
        if (f.exists()) {
            if (!f.delete()) {
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.failedtodelete", new Object[]{f.getName(), f.getAbsolutePath()}));
                }
            }
        } else {
            this.getLog().debug((CharSequence)Messages.getString("EclipseCleanMojo.nofilefound", f.getName()));
        }
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }
}

