/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugin.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.UnpackFileMarkerHandler;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnpackMojo
extends AbstractFromConfigurationMojo {
    private File markersDirectory;
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            return;
        }
        List<ArtifactItem> processedItems = this.getProcessedArtifactItems(false);
        for (ArtifactItem artifactItem : processedItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.unpackArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem.getArtifact().getFile().getName() + " already unpacked."));
        }
    }

    private void unpackArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(artifactItem, this.markersDirectory);
        this.unpack(artifactItem.getArtifact().getFile(), artifactItem.getOutputDirectory(), artifactItem.getIncludes(), artifactItem.getExcludes());
        handler.setMarker();
    }

    @Override
    ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        UnpackFileMarkerHandler handler = new UnpackFileMarkerHandler(item, this.markersDirectory);
        return new MarkerFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), handler);
    }

    @Override
    protected List<ArtifactItem> getProcessedArtifactItems(boolean removeVersion) throws MojoExecutionException {
        List<ArtifactItem> items = super.getProcessedArtifactItems(removeVersion);
        for (ArtifactItem artifactItem : items) {
            if (StringUtils.isEmpty((String)artifactItem.getIncludes())) {
                artifactItem.setIncludes(this.getIncludes());
            }
            if (!StringUtils.isEmpty((String)artifactItem.getExcludes())) continue;
            artifactItem.setExcludes(this.getExcludes());
        }
        return items;
    }

    public File getMarkersDirectory() {
        return this.markersDirectory;
    }

    public void setMarkersDirectory(File theMarkersDirectory) {
        this.markersDirectory = theMarkersDirectory;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

