/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.jira.JiraQueryBuilder;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterQueryBuilder
implements JiraQueryBuilder {
    private String filter = "";
    private Log log;
    private StringBuilder query = new StringBuilder();
    private final Map<String, String> priorityMap = new HashMap<String, String>(8);
    private final Map<String, String> resolutionMap = new HashMap<String, String>(8);
    private final Map<String, String> statusMap = new HashMap<String, String>(8);
    private final Map<String, String> typeMap = new HashMap<String, String>(8);

    public ParameterQueryBuilder(Log log) {
        this.log = log;
        this.priorityMap.put("Blocker", "1");
        this.priorityMap.put("Critical", "2");
        this.priorityMap.put("Major", "3");
        this.priorityMap.put("Minor", "4");
        this.priorityMap.put("Trivial", "5");
        this.resolutionMap.put("Unresolved", "-1");
        this.resolutionMap.put("Fixed", "1");
        this.resolutionMap.put("Won't Fix", "2");
        this.resolutionMap.put("Duplicate", "3");
        this.resolutionMap.put("Incomplete", "4");
        this.resolutionMap.put("Cannot Reproduce", "5");
        this.statusMap.put("Open", "1");
        this.statusMap.put("In Progress", "3");
        this.statusMap.put("Reopened", "4");
        this.statusMap.put("Resolved", "5");
        this.statusMap.put("Closed", "6");
        this.typeMap.put("Bug", "1");
        this.typeMap.put("New Feature", "2");
        this.typeMap.put("Task", "3");
        this.typeMap.put("Improvement", "4");
        this.typeMap.put("Wish", "5");
        this.typeMap.put("Test", "6");
        this.typeMap.put("Sub-task", "7");
    }

    @Override
    public String build() {
        if (this.filter != null && this.filter.length() > 0) {
            return this.filter;
        }
        return this.query.toString();
    }

    @Override
    public JiraQueryBuilder components(String components) {
        if (components != null) {
            String[] componentsArr;
            for (String component : componentsArr = components.split(",")) {
                if ((component = component.trim()).length() <= 0) continue;
                this.query.append("&component=").append(component);
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder components(List<String> components) {
        if (components != null) {
            for (String component : components) {
                if ((component = component.trim()).length() <= 0) continue;
                this.query.append("&component=").append(component);
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public JiraQueryBuilder fixVersion(String fixVersion) {
        return this;
    }

    @Override
    public JiraQueryBuilder fixVersionIds(String fixVersionIds) {
        if (fixVersionIds != null) {
            String[] fixVersions = fixVersionIds.split(",");
            for (int i = 0; i < fixVersions.length; ++i) {
                if (fixVersions[i].length() <= 0) continue;
                this.query.append("&fixfor=").append(fixVersions[i].trim());
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder fixVersionIds(List<String> fixVersionIds) {
        throw new RuntimeException("fixVersionIds(List) not supported for very old parameter queries.");
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public JiraQueryBuilder priorityIds(String priorityIds) {
        if (priorityIds != null) {
            String[] prios;
            for (String prio : prios = priorityIds.split(",")) {
                String priorityParam = this.priorityMap.get(prio = prio.trim());
                if (priorityParam == null) continue;
                this.query.append("&priorityIds=").append(priorityParam);
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder priorityIds(List<String> priorityIds) {
        throw new RuntimeException("priorityIds(List) not supported for old parameter queries.");
    }

    @Override
    public JiraQueryBuilder project(String project) {
        return this;
    }

    @Override
    public JiraQueryBuilder resolutionIds(String resolutionIds) {
        if (resolutionIds != null) {
            String[] resos;
            for (String reso : resos = resolutionIds.split(",")) {
                String resoParam = this.resolutionMap.get(reso = reso.trim());
                if (resoParam == null) continue;
                this.query.append("&resolutionIds=").append(resoParam);
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder resolutionIds(List<String> resolutionIds) {
        throw new RuntimeException("resolutionIds(List) not supported for old ParameterQueryBuilder");
    }

    @Override
    public JiraQueryBuilder sortColumnNames(String sortColumnNames) {
        int validSortColumnNames = 0;
        if (sortColumnNames != null) {
            String[] sortColumnNamesArray = sortColumnNames.split(",");
            for (int i = sortColumnNamesArray.length - 1; i >= 0; --i) {
                String lowerColumnName = sortColumnNamesArray[i].trim().toLowerCase(Locale.ENGLISH);
                boolean descending = false;
                String fieldName = null;
                if (lowerColumnName.endsWith("desc")) {
                    descending = true;
                    lowerColumnName = lowerColumnName.substring(0, lowerColumnName.length() - 4).trim();
                } else if (lowerColumnName.endsWith("asc")) {
                    descending = false;
                    lowerColumnName = lowerColumnName.substring(0, lowerColumnName.length() - 3).trim();
                }
                if ("key".equals(lowerColumnName)) {
                    fieldName = "issuekey";
                } else if ("summary".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("status".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("resolution".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("assignee".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("reporter".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("type".equals(lowerColumnName)) {
                    fieldName = "issuetype";
                } else if ("priority".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("version".equals(lowerColumnName)) {
                    fieldName = "versions";
                } else if ("fix version".equals(lowerColumnName)) {
                    fieldName = "fixVersions";
                } else if ("component".equals(lowerColumnName)) {
                    fieldName = "components";
                } else if ("created".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                } else if ("updated".equals(lowerColumnName)) {
                    fieldName = lowerColumnName;
                }
                if (fieldName != null) {
                    this.query.append("&sorter/field=");
                    this.query.append(fieldName);
                    this.query.append("&sorter/order=");
                    this.query.append(descending ? "DESC" : "ASC");
                    ++validSortColumnNames;
                    continue;
                }
                this.getLog().error((CharSequence)("maven-changes-plugin: The configured value '" + lowerColumnName + "' for sortColumnNames is not correct."));
            }
            if (validSortColumnNames == 0) {
                this.getLog().error((CharSequence)("maven-changes-plugin: None of the configured sortColumnNames '" + sortColumnNames + "' are correct."));
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder statusIds(String statusIds) {
        if (statusIds != null) {
            String[] stats;
            for (String stat : stats = statusIds.split(",")) {
                String statusParam = this.statusMap.get(stat = stat.trim());
                if (statusParam != null) {
                    this.query.append("&statusIds=").append(statusParam);
                    continue;
                }
                try {
                    Integer.parseInt(stat);
                    this.query.append("&statusIds=").append(stat);
                }
                catch (NumberFormatException nfe) {
                    this.getLog().error((CharSequence)("maven-changes-plugin: invalid statusId " + stat));
                }
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder statusIds(List<String> statusIds) {
        throw new RuntimeException("statusIds(List) not supported for old parameter queries.");
    }

    @Override
    public JiraQueryBuilder typeIds(String typeIds) {
        if (typeIds != null) {
            String[] types;
            for (String type : types = typeIds.split(",")) {
                String typeParam = this.typeMap.get(type.trim());
                if (typeParam == null) continue;
                this.query.append("&type=").append(typeParam);
            }
        }
        return this;
    }

    @Override
    public JiraQueryBuilder typeIds(List<String> typeIds) {
        throw new RuntimeException("typeIds(List) not supported for old ParameterQueryBuilder");
    }
}

