/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jira;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.proxy.ProxyInfo;

public class JiraHelper {
    private static final String PID = "pid=";

    static Map getJiraUrlAndProjectId(String issueManagementUrl) {
        String jiraUrl;
        String url = issueManagementUrl;
        if (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf(47));
        }
        int pos = url.indexOf(63);
        String id = "";
        if (pos >= 0) {
            id = url.substring(url.lastIndexOf(61) + 1);
        }
        if ((jiraUrl = url.substring(0, url.lastIndexOf(47))).endsWith("secure")) {
            jiraUrl = jiraUrl.substring(0, jiraUrl.lastIndexOf(47));
        } else {
            int index = jiraUrl.indexOf("/browse");
            if (index != -1) {
                jiraUrl = jiraUrl.substring(0, index);
            }
        }
        HashMap<String, String> urlMap = new HashMap<String, String>(4);
        urlMap.put("url", jiraUrl);
        urlMap.put("id", id);
        return urlMap;
    }

    public static String getPidFromJira(Log log, String issueManagementUrl, HttpClient client) {
        String projectPage;
        String jiraId = null;
        GetMethod gm = new GetMethod(issueManagementUrl);
        try {
            client.executeMethod((HttpMethod)gm);
            log.debug((CharSequence)"Successfully reached JIRA.");
            projectPage = gm.getResponseBodyAsString();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((CharSequence)"Unable to reach the JIRA project page:", (Throwable)e);
            } else {
                log.error((CharSequence)("Unable to reach the JIRA project page. Cause is: " + e.getLocalizedMessage()));
            }
            return null;
        }
        int pidIndex = projectPage.indexOf(PID);
        if (pidIndex == -1) {
            log.error((CharSequence)("Unable to extract a JIRA pid from the page at the url " + issueManagementUrl));
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            Number pidNumber = nf.parse(projectPage, new ParsePosition(pidIndex + PID.length()));
            jiraId = Integer.toString(pidNumber.intValue());
            log.debug((CharSequence)("Found the pid " + jiraId + " at " + issueManagementUrl));
        }
        return jiraId;
    }

    public static boolean validateNonProxyHosts(ProxyInfo proxy, String targetHost) {
        String tHost = targetHost;
        if (tHost == null) {
            tHost = new String();
        }
        if (proxy == null) {
            return false;
        }
        String nonProxyHosts = proxy.getNonProxyHosts();
        if (nonProxyHosts == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!tHost.matches(pattern = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"))) continue;
            return true;
        }
        return false;
    }

    private JiraHelper() {
    }
}

