/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Component;

public class Release
implements Serializable {
    private String version;
    private String dateRelease;
    private String description;
    private List<Action> actions;
    private final List<Component> components = new ArrayList<Component>();

    public void addAction(Action action) {
        if (!(action instanceof Action)) {
            throw new ClassCastException("Release.addActions(action) parameter must be instanceof " + Action.class.getName());
        }
        this.getActions().add(action);
    }

    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        return this.actions;
    }

    public String getDateRelease() {
        return this.dateRelease;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeAction(Action action) {
        if (!(action instanceof Action)) {
            throw new ClassCastException("Release.removeActions(action) parameter must be instanceof " + Action.class.getName());
        }
        this.getActions().remove(action);
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setDateRelease(String dateRelease) {
        this.dateRelease = dateRelease;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Action> getActions(String type) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action action : this.getActions()) {
            if (action.getType() == null || !action.getType().equalsIgnoreCase(type)) continue;
            actions.add(action);
        }
        return actions;
    }

    public void addComponent(String name, Release release) {
        Component component = new Component();
        component.setName(name);
        component.setDescription(release.getDescription());
        component.setActions(release.getActions());
        this.components.add(component);
    }

    public List<Component> getComponents() {
        return this.components;
    }
}

