/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changelog;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.changelog.ChangeLogReport;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.codehaus.doxia.sink.Sink;

public class DeveloperActivityReport
extends ChangeLogReport {
    private List developers;
    private HashMap commits;
    private HashMap files;

    public String getDescription(Locale locale) {
        return "Generated developer activity report from SCM.";
    }

    public String getName(Locale locale) {
        return "Developer Activity";
    }

    public String getOutputName() {
        return "dev-activity";
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.dev-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.dev-activity.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(List changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.dev-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.dev-activity.mainTitle"));
        sink.sectionTitle1_();
        if (this.developers.isEmpty()) {
            sink.paragraph();
            sink.text(bundle.getString("report.dev-activity.noDevelopers"));
            sink.paragraph_();
        } else {
            Iterator sets = changeLogSets.iterator();
            while (sets.hasNext()) {
                ChangeLogSet set = (ChangeLogSet)sets.next();
                this.doChangedSets(set, bundle, sink);
            }
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.table_();
    }

    private void doChangedSets(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        this.doChangeSetTitle(set, bundle, sink);
        this.doSummary(set, bundle, sink);
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.dev-activity.developer"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.TotalCommits"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.dev-activity.filesChanged"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.doDeveloperRows(set, sink);
        sink.table_();
        sink.section2_();
    }

    private void doDeveloperRows(ChangeLogSet set, Sink sink) {
        this.initDeveloperDetails(set);
        Iterator i = this.developers.iterator();
        while (i.hasNext()) {
            HashMap devFiles;
            LinkedList devCommits;
            Developer developer = (Developer)i.next();
            String name = developer.getName();
            String id = developer.getId();
            if (!this.commits.containsKey(name)) {
                if (!this.commits.containsKey(id)) continue;
                devCommits = (LinkedList)this.commits.get(id);
                devFiles = (HashMap)this.files.get(id);
            } else {
                devCommits = (LinkedList)this.commits.get(name);
                devFiles = (HashMap)this.files.get(name);
            }
            sink.tableRow();
            sink.tableCell();
            sink.link("team-list.html#" + developer.getId());
            sink.text(name);
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + devCommits.size());
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + devFiles.size());
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    private void initDeveloperDetails(ChangeLogSet set) {
        this.commits = new HashMap();
        this.files = new HashMap();
        this.countDevCommits(set.getChangeSets());
        this.countDevFiles(set.getChangeSets());
    }

    private void countDevCommits(Collection entries) {
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ChangeSet entry = (ChangeSet)i.next();
            String developer = entry.getAuthor();
            LinkedList list = this.commits.containsKey(developer) ? (LinkedList)this.commits.get(developer) : new LinkedList();
            list.add(entry);
            this.commits.put(developer, list);
        }
    }

    private void countDevFiles(Collection entries) {
        Iterator i2 = entries.iterator();
        while (i2.hasNext()) {
            ChangeSet entry = (ChangeSet)i2.next();
            String developer = entry.getAuthor();
            HashMap filesMap = this.files.containsKey(developer) ? (HashMap)this.files.get(developer) : new HashMap();
            Iterator i3 = entry.getFiles().iterator();
            while (i3.hasNext()) {
                ChangeFile file = (ChangeFile)i3.next();
                filesMap.put(file.getName(), file);
            }
            this.files.put(developer, filesMap);
        }
    }
}

