/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.phase;

import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugins.assembly.archive.phase.wrappers.RepoBuilderConfigSourceWrapper;
import org.apache.maven.plugins.assembly.archive.phase.wrappers.RepoInfoWrapper;
import org.apache.maven.plugins.assembly.archive.task.AddDirectoryTask;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.Repository;
import org.apache.maven.plugins.assembly.repository.RepositoryAssembler;
import org.apache.maven.plugins.assembly.repository.RepositoryAssemblyException;
import org.apache.maven.plugins.assembly.repository.RepositoryBuilderConfigSource;
import org.apache.maven.plugins.assembly.repository.model.RepositoryInfo;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="repositories")
public class RepositoryAssemblyPhase
implements AssemblyArchiverPhase,
PhaseOrder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryAssemblyPhase.class);
    private final RepositoryAssembler repositoryAssembler;

    @Inject
    public RepositoryAssemblyPhase(RepositoryAssembler repositoryAssembler) {
        this.repositoryAssembler = Objects.requireNonNull(repositoryAssembler);
    }

    @Override
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        List<Repository> repositoriesList = assembly.getRepositories();
        File tempRoot = configSource.getTemporaryRootDirectory();
        if (!repositoriesList.isEmpty()) {
            LOGGER.warn("");
            LOGGER.warn("The <repository> element in assembly descriptor is deprecated,");
            LOGGER.warn("support for it will be removed. For details see:");
            LOGGER.warn("https://issues.apache.org/jira/browse/MASSEMBLY-957");
            LOGGER.warn("");
        }
        for (Repository repository : repositoriesList) {
            int fileMode;
            String outputDirectory = AssemblyFormatUtils.getOutputDirectory(repository.getOutputDirectory(), configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(configSource.getProject()), AssemblyFormatUtils.artifactProjectInterpolator(null));
            File repositoryDirectory = new File(tempRoot, outputDirectory);
            if (!repositoryDirectory.exists()) {
                repositoryDirectory.mkdirs();
            }
            try {
                LOGGER.debug("Assembling repository to: " + repositoryDirectory);
                this.repositoryAssembler.buildRemoteRepository(repositoryDirectory, this.wrap(repository), this.wrap(configSource));
                LOGGER.debug("Finished assembling repository to: " + repositoryDirectory);
            }
            catch (RepositoryAssemblyException e) {
                throw new ArchiveCreationException("Failed to assemble repository: " + e.getMessage(), e);
            }
            AddDirectoryTask task = new AddDirectoryTask(repositoryDirectory);
            int dirMode = TypeConversionUtils.modeToInt(repository.getDirectoryMode(), LOGGER);
            if (dirMode != -1) {
                task.setDirectoryMode(dirMode);
            }
            if ((fileMode = TypeConversionUtils.modeToInt(repository.getFileMode(), LOGGER)) != -1) {
                task.setFileMode(fileMode);
            }
            task.setOutputDirectory(outputDirectory);
            task.execute(archiver);
        }
    }

    private RepositoryBuilderConfigSource wrap(AssemblerConfigurationSource configSource) {
        return new RepoBuilderConfigSourceWrapper(configSource);
    }

    private RepositoryInfo wrap(Repository repository) {
        return new RepoInfoWrapper(repository);
    }

    @Override
    public int order() {
        return 50;
    }
}

