/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.Plugin;
import org.apache.maven.mercury.repository.metadata.PluginOperand;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class RemovePluginOperation
implements MetadataOperation {
    private static final Language lang = new DefaultLanguage(RemovePluginOperation.class);
    private Plugin plugin;

    public RemovePluginOperation(PluginOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public void setOperand(Object data) throws MetadataException {
        if (data == null || !(data instanceof PluginOperand)) {
            throw new MetadataException(lang.getMessage("bad.operand", new String[]{"PluginOperand", data == null ? "null" : data.getClass().getName()}));
        }
        this.plugin = ((PluginOperand)data).getOperand();
    }

    public boolean perform(Metadata metadata) throws MetadataException {
        if (metadata == null) {
            return false;
        }
        List plugins = metadata.getPlugins();
        if (plugins != null && plugins.size() > 0) {
            Iterator pi = plugins.iterator();
            while (pi.hasNext()) {
                Plugin p = (Plugin)pi.next();
                if (!p.getArtifactId().equals(this.plugin.getArtifactId())) continue;
                pi.remove();
                return true;
            }
        }
        return false;
    }
}

