/*
 * $Id$
 */

package org.apache.maven.toolchain.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.*;

/**
 * Class MavenToolchainsXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class MavenToolchainsXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field serializer
     */
    private org.codehaus.plexus.util.xml.pull.XmlSerializer serializer;

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param toolchains
     */
    public void write(Writer writer, PersistedToolchains toolchains)
        throws java.io.IOException
    {
        serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( toolchains.getModelEncoding(), null );
        writePersistedToolchains( toolchains, "toolchains", serializer );
        serializer.endDocument();
    } //-- void write(Writer, PersistedToolchains) 

    /**
     * Method writePersistedToolchains
     * 
     * @param persistedToolchains
     * @param serializer
     * @param tagName
     */
    private void writePersistedToolchains(PersistedToolchains persistedToolchains, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( persistedToolchains != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( persistedToolchains.getToolchains() != null && persistedToolchains.getToolchains().size() > 0 )
            {
                for ( Iterator iter = persistedToolchains.getToolchains().iterator(); iter.hasNext(); )
                {
                    ToolchainModel o = (ToolchainModel) iter.next();
                    writeToolchainModel( o, "toolchain", serializer );
                }
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writePersistedToolchains(PersistedToolchains, String, XmlSerializer) 

    /**
     * Method writeToolchainModel
     * 
     * @param toolchainModel
     * @param serializer
     * @param tagName
     */
    private void writeToolchainModel(ToolchainModel toolchainModel, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( toolchainModel != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            if ( toolchainModel.getType() != null )
            {
                serializer.startTag( NAMESPACE, "type" ).text( toolchainModel.getType() ).endTag( NAMESPACE, "type" );
            }
            if ( toolchainModel.getProvides() != null )
            {
                ((Xpp3Dom) toolchainModel.getProvides()).writeToSerializer( NAMESPACE, serializer );
            }
            if ( toolchainModel.getConfiguration() != null )
            {
                ((Xpp3Dom) toolchainModel.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
            }
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeToolchainModel(ToolchainModel, String, XmlSerializer) 

}
