/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.project.builder.profile.ActiveProfileMatcher;
import org.apache.maven.project.builder.profile.ByDefaultMatcher;
import org.apache.maven.project.builder.profile.FileMatcher;
import org.apache.maven.project.builder.profile.JdkMatcher;
import org.apache.maven.project.builder.profile.OperatingSystemMatcher;
import org.apache.maven.project.builder.profile.PropertyMatcher;
import org.apache.maven.shared.model.DataSourceException;
import org.apache.maven.shared.model.InterpolatorProperty;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileContext {
    private ModelDataSource modelDataSource;
    private List<InterpolatorProperty> properties;
    List<ActiveProfileMatcher> matchers = Collections.unmodifiableList(Arrays.asList(new ByDefaultMatcher(), new FileMatcher(), new JdkMatcher(), new OperatingSystemMatcher(), new PropertyMatcher()));

    public ProfileContext(ModelDataSource modelDataSource, List<InterpolatorProperty> properties) {
        this.modelDataSource = modelDataSource;
        this.properties = new ArrayList<InterpolatorProperty>(properties);
    }

    public Collection<ModelContainer> getActiveProfiles() throws DataSourceException {
        ArrayList<ModelContainer> matchedContainers = new ArrayList<ModelContainer>();
        List modelContainers = this.modelDataSource.queryFor(ProjectUri.Profiles.Profile.xUri);
        for (ModelContainer mc : modelContainers) {
            for (ActiveProfileMatcher matcher : this.matchers) {
                if (!matcher.isMatch(mc, this.properties)) continue;
                matchedContainers.add(mc);
            }
        }
        return matchedContainers;
    }
}

