/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.property;

import hidden.org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import hidden.org.apache.jackrabbit.webdav.property.DavProperty;
import hidden.org.apache.jackrabbit.webdav.property.DavPropertyName;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HrefProperty
extends AbstractDavProperty {
    private static Logger log = LoggerFactory.getLogger(HrefProperty.class);
    private final String[] value;

    public HrefProperty(DavPropertyName name, String value, boolean isInvisibleInAllprop) {
        super(name, isInvisibleInAllprop);
        this.value = new String[]{value};
    }

    public HrefProperty(DavPropertyName name, String[] value, boolean isInvisibleInAllprop) {
        super(name, isInvisibleInAllprop);
        this.value = value;
    }

    public HrefProperty(DavProperty prop) {
        super(prop.getName(), prop.isInvisibleInAllprop());
        if (prop instanceof HrefProperty) {
            this.value = ((HrefProperty)prop).value;
        } else {
            ArrayList<String> hrefList = new ArrayList<String>();
            Object val = prop.getValue();
            if (val instanceof List) {
                Iterator it = ((List)val).iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof Element && "href".equals(((Element)o).getLocalName())) {
                        String href = DomUtil.getText((Element)o);
                        if (href != null) {
                            hrefList.add(href);
                            continue;
                        }
                        log.warn("Valid DAV:href element expected instead of " + o.toString());
                        continue;
                    }
                    log.warn("DAV: href element expected in the content of " + this.getName().toString());
                }
            } else if (val instanceof Element && "href".equals(((Element)val).getLocalName())) {
                String href = DomUtil.getTextTrim((Element)val);
                if (href != null) {
                    hrefList.add(href);
                } else {
                    log.warn("Valid DAV:href element expected instead of " + val.toString());
                }
            }
            this.value = hrefList.toArray(new String[hrefList.size()]);
        }
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof String[]) {
                String[] hrefs = (String[])value;
                for (int i = 0; i < hrefs.length; ++i) {
                    elem.appendChild(DomUtil.hrefToXml(hrefs[i], document));
                }
            } else {
                elem.appendChild(DomUtil.hrefToXml(value.toString(), document));
            }
        }
        return elem;
    }

    public Object getValue() {
        return this.value;
    }

    public List getHrefs() {
        return this.value != null ? Arrays.asList(this.value) : new ArrayList();
    }
}

