/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Version;

public class SpellChecker
implements Closeable {
    public static final float DEFAULT_ACCURACY = 0.5f;
    public static final String F_WORD = "word";
    Directory spellIndex;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexSearcher searcher;
    private final Object searcherLock = new Object();
    private final Object modifyCurrentIndexLock = new Object();
    private volatile boolean closed = false;
    private float accuracy = 0.5f;
    private StringDistance sd;
    private Comparator<SuggestWord> comparator;

    public SpellChecker(Directory spellIndex, StringDistance sd) throws IOException {
        this(spellIndex, sd, SuggestWordQueue.DEFAULT_COMPARATOR);
    }

    public SpellChecker(Directory spellIndex) throws IOException {
        this(spellIndex, new LevensteinDistance());
    }

    public SpellChecker(Directory spellIndex, StringDistance sd, Comparator<SuggestWord> comparator) throws IOException {
        this.setSpellIndex(spellIndex);
        this.setStringDistance(sd);
        this.comparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpellIndex(Directory spellIndexDir) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            if (!DirectoryReader.indexExists((Directory)spellIndexDir)) {
                IndexWriter writer = new IndexWriter(spellIndexDir, new IndexWriterConfig(Version.LUCENE_CURRENT, null));
                writer.close();
            }
            this.swapSearcher(spellIndexDir);
        }
    }

    public void setComparator(Comparator<SuggestWord> comparator) {
        this.comparator = comparator;
    }

    public Comparator<SuggestWord> getComparator() {
        return this.comparator;
    }

    public void setStringDistance(StringDistance sd) {
        this.sd = sd;
    }

    public StringDistance getStringDistance() {
        return this.sd;
    }

    public void setAccuracy(float acc) {
        this.accuracy = acc;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public String[] suggestSimilar(String word, int numSug) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX);
    }

    public String[] suggestSimilar(String word, int numSug, float accuracy) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX, accuracy);
    }

    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, SuggestMode suggestMode) throws IOException {
        return this.suggestSimilar(word, numSug, ir, field, suggestMode, this.accuracy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, SuggestMode suggestMode, float accuracy) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            int goalFreq;
            if (ir == null || field == null) {
                suggestMode = SuggestMode.SUGGEST_ALWAYS;
            }
            if (suggestMode == SuggestMode.SUGGEST_ALWAYS) {
                ir = null;
                field = null;
            }
            int lengthWord = word.length();
            int freq = ir != null && field != null ? ir.docFreq(new Term(field, word)) : 0;
            int n = goalFreq = suggestMode == SuggestMode.SUGGEST_MORE_POPULAR ? freq : 0;
            if (suggestMode == SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX && freq > 0) {
                String[] stringArray = new String[]{word};
                return stringArray;
            }
            BooleanQuery query = new BooleanQuery();
            for (int ng = SpellChecker.getMin(lengthWord); ng <= SpellChecker.getMax(lengthWord); ++ng) {
                String key = "gram" + ng;
                String[] grams = SpellChecker.formGrams(word, ng);
                if (grams.length == 0) continue;
                if (this.bStart > 0.0f) {
                    SpellChecker.add(query, "start" + ng, grams[0], this.bStart);
                }
                if (this.bEnd > 0.0f) {
                    SpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
                }
                for (int i = 0; i < grams.length; ++i) {
                    SpellChecker.add(query, key, grams[i]);
                }
            }
            int maxHits = 10 * numSug;
            ScoreDoc[] hits = indexSearcher.search((Query)query, null, (int)maxHits).scoreDocs;
            SuggestWordQueue sugQueue = new SuggestWordQueue(numSug, this.comparator);
            int stop = Math.min(hits.length, maxHits);
            SuggestWord sugWord = new SuggestWord();
            for (int i = 0; i < stop; ++i) {
                sugWord.string = indexSearcher.doc(hits[i].doc).get(F_WORD);
                if (sugWord.string.equals(word)) continue;
                sugWord.score = this.sd.getDistance(word, sugWord.string);
                if (sugWord.score < accuracy) continue;
                if (ir != null && field != null) {
                    sugWord.freq = ir.docFreq(new Term(field, sugWord.string));
                    if (suggestMode == SuggestMode.SUGGEST_MORE_POPULAR && goalFreq > sugWord.freq || sugWord.freq < 1) continue;
                }
                sugQueue.insertWithOverflow(sugWord);
                if (sugQueue.size() == numSug) {
                    accuracy = ((SuggestWord)sugQueue.top()).score;
                }
                sugWord = new SuggestWord();
            }
            String[] list = new String[sugQueue.size()];
            for (int i = sugQueue.size() - 1; i >= 0; --i) {
                list[i] = ((SuggestWord)sugQueue.pop()).string;
            }
            String[] stringArray = list;
            return stringArray;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndex() throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            IndexWriter writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_CURRENT, null).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
            writer.close();
            this.swapSearcher(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String word) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            boolean bl = indexSearcher.getIndexReader().docFreq(new Term(F_WORD, word)) > 0;
            return bl;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void indexDictionary(Dictionary dict, IndexWriterConfig config, boolean fullMerge) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            IndexWriter writer = new IndexWriter(dir, config);
            IndexSearcher indexSearcher = this.obtainSearcher();
            ArrayList<TermsEnum> termsEnums = new ArrayList<TermsEnum>();
            IndexReader reader = this.searcher.getIndexReader();
            if (reader.maxDoc() > 0) {
                for (AtomicReaderContext ctx : reader.leaves()) {
                    Terms terms = ctx.reader().terms(F_WORD);
                    if (terms == null) continue;
                    termsEnums.add(terms.iterator(null));
                }
            }
            boolean isEmpty = termsEnums.isEmpty();
            try {
                BytesRef currentTerm;
                BytesRefIterator iter = dict.getWordsIterator();
                block7: while ((currentTerm = iter.next()) != null) {
                    String word = currentTerm.utf8ToString();
                    int len = word.length();
                    if (len < 3) continue;
                    if (!isEmpty) {
                        for (TermsEnum te : termsEnums) {
                            if (!te.seekExact(currentTerm)) continue;
                            continue block7;
                        }
                    }
                    Document doc = SpellChecker.createDocument(word, SpellChecker.getMin(len), SpellChecker.getMax(len));
                    writer.addDocument((Iterable)doc);
                }
            }
            finally {
                this.releaseSearcher(indexSearcher);
            }
            if (fullMerge) {
                writer.forceMerge(1);
            }
            writer.close();
            this.swapSearcher(dir);
        }
    }

    private static int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private static int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    private static Document createDocument(String text, int ng1, int ng2) {
        Document doc = new Document();
        StringField f = new StringField(F_WORD, text, Field.Store.YES);
        doc.add((IndexableField)f);
        SpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                FieldType ft = new FieldType(StringField.TYPE_NOT_STORED);
                ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS);
                Field ngramField = new Field(key, gram, ft);
                doc.add((IndexableField)ngramField);
                if (i == 0) {
                    StringField startField = new StringField("start" + ng, gram, Field.Store.NO);
                    doc.add((IndexableField)startField);
                }
                end = gram;
            }
            if (end == null) continue;
            StringField endField = new StringField("end" + ng, end, Field.Store.NO);
            doc.add((IndexableField)endField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher obtainSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.searcher.getIndexReader().incRef();
            return this.searcher;
        }
    }

    private void releaseSearcher(IndexSearcher aSearcher) throws IOException {
        aSearcher.getIndexReader().decRef();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("Spellchecker has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.closed = true;
            if (this.searcher != null) {
                this.searcher.getIndexReader().close();
            }
            this.searcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapSearcher(Directory dir) throws IOException {
        IndexSearcher indexSearcher = this.createSearcher(dir);
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.closed) {
                indexSearcher.getIndexReader().close();
                throw new AlreadyClosedException("Spellchecker has been closed");
            }
            if (this.searcher != null) {
                this.searcher.getIndexReader().close();
            }
            this.searcher = indexSearcher;
            this.spellIndex = dir;
        }
    }

    IndexSearcher createSearcher(Directory dir) throws IOException {
        return new IndexSearcher((IndexReader)DirectoryReader.open((Directory)dir));
    }

    boolean isClosed() {
        return this.closed;
    }
}

