/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.DoubleMetaphoneFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class DoubleMetaphoneFilterFactory
extends TokenFilterFactory {
    public static final String INJECT = "inject";
    public static final String MAX_CODE_LENGTH = "maxCodeLength";
    public static final int DEFAULT_MAX_CODE_LENGTH = 4;
    private boolean inject = true;
    private int maxCodeLength = 4;

    public void init(Map<String, String> args) {
        super.init(args);
        this.inject = this.getBoolean(INJECT, true);
        if (args.get(MAX_CODE_LENGTH) != null) {
            this.maxCodeLength = Integer.parseInt(args.get(MAX_CODE_LENGTH));
        }
    }

    public DoubleMetaphoneFilter create(TokenStream input) {
        return new DoubleMetaphoneFilter(input, this.maxCodeLength, this.inject);
    }
}

