/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedSum;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.QuorumState;

public class KafkaRaftMetrics
implements AutoCloseable {
    private final Metrics metrics;
    private OffsetAndEpoch logEndOffset;
    private int numUnknownVoterConnections;
    private OptionalLong electionStartMs;
    private OptionalLong pollStartMs;
    private OptionalLong pollEndMs;
    private final MetricName currentLeaderIdMetricName;
    private final MetricName currentVotedIdMetricName;
    private final MetricName currentEpochMetricName;
    private final MetricName currentStateMetricName;
    private final MetricName highWatermarkMetricName;
    private final MetricName logEndOffsetMetricName;
    private final MetricName logEndEpochMetricName;
    private final MetricName numUnknownVoterConnectionsMetricName;
    private final Sensor commitTimeSensor;
    private final Sensor electionTimeSensor;
    private final Sensor fetchRecordsSensor;
    private final Sensor appendRecordsSensor;
    private final Sensor pollIdleSensor;

    public KafkaRaftMetrics(Metrics metrics, String metricGrpPrefix, QuorumState state) {
        this.metrics = metrics;
        String metricGroupName = metricGrpPrefix + "-metrics";
        this.pollStartMs = OptionalLong.empty();
        this.pollEndMs = OptionalLong.empty();
        this.electionStartMs = OptionalLong.empty();
        this.numUnknownVoterConnections = 0;
        this.logEndOffset = new OffsetAndEpoch(0L, 0);
        this.currentStateMetricName = metrics.metricName("current-state", metricGroupName, "The current state of this member; possible values are leader, candidate, voted, follower, unattached");
        Gauge stateProvider = (mConfig, currentTimeMs) -> {
            if (state.isLeader()) {
                return "leader";
            }
            if (state.isCandidate()) {
                return "candidate";
            }
            if (state.isVoted()) {
                return "voted";
            }
            if (state.isFollower()) {
                return "follower";
            }
            return "unattached";
        };
        metrics.addMetric(this.currentStateMetricName, null, (MetricValueProvider)stateProvider);
        this.currentLeaderIdMetricName = metrics.metricName("current-leader", metricGroupName, "The current quorum leader's id; -1 indicates unknown");
        metrics.addMetric(this.currentLeaderIdMetricName, (mConfig, currentTimeMs) -> state.leaderId().orElse(-1));
        this.currentVotedIdMetricName = metrics.metricName("current-vote", metricGroupName, "The current voted leader's id; -1 indicates not voted for anyone");
        metrics.addMetric(this.currentVotedIdMetricName, (mConfig, currentTimeMs) -> {
            if (state.isLeader() || state.isCandidate()) {
                return state.localIdOrThrow();
            }
            if (state.isVoted()) {
                return state.votedStateOrThrow().votedId();
            }
            return -1.0;
        });
        this.currentEpochMetricName = metrics.metricName("current-epoch", metricGroupName, "The current quorum epoch.");
        metrics.addMetric(this.currentEpochMetricName, (mConfig, currentTimeMs) -> state.epoch());
        this.highWatermarkMetricName = metrics.metricName("high-watermark", metricGroupName, "The high watermark maintained on this member; -1 if it is unknown");
        metrics.addMetric(this.highWatermarkMetricName, (mConfig, currentTimeMs) -> state.highWatermark().map(hw -> hw.offset).orElse(-1L).longValue());
        this.logEndOffsetMetricName = metrics.metricName("log-end-offset", metricGroupName, "The current raft log end offset.");
        metrics.addMetric(this.logEndOffsetMetricName, (mConfig, currentTimeMs) -> this.logEndOffset.offset);
        this.logEndEpochMetricName = metrics.metricName("log-end-epoch", metricGroupName, "The current raft log end epoch.");
        metrics.addMetric(this.logEndEpochMetricName, (mConfig, currentTimeMs) -> this.logEndOffset.epoch);
        this.numUnknownVoterConnectionsMetricName = metrics.metricName("number-unknown-voter-connections", metricGroupName, "The number of voter connections recognized at this member.");
        metrics.addMetric(this.numUnknownVoterConnectionsMetricName, (mConfig, currentTimeMs) -> this.numUnknownVoterConnections);
        this.commitTimeSensor = metrics.sensor("commit-latency");
        this.commitTimeSensor.add(metrics.metricName("commit-latency-avg", metricGroupName, "The average time in milliseconds to commit an entry in the raft log."), (MeasurableStat)new Avg());
        this.commitTimeSensor.add(metrics.metricName("commit-latency-max", metricGroupName, "The maximum time in milliseconds to commit an entry in the raft log."), (MeasurableStat)new Max());
        this.electionTimeSensor = metrics.sensor("election-latency");
        this.electionTimeSensor.add(metrics.metricName("election-latency-avg", metricGroupName, "The average time in milliseconds to elect a new leader."), (MeasurableStat)new Avg());
        this.electionTimeSensor.add(metrics.metricName("election-latency-max", metricGroupName, "The maximum time in milliseconds to elect a new leader."), (MeasurableStat)new Max());
        this.fetchRecordsSensor = metrics.sensor("fetch-records");
        this.fetchRecordsSensor.add(metrics.metricName("fetch-records-rate", metricGroupName, "The average number of records fetched from the leader of the raft quorum."), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new WindowedSum()));
        this.appendRecordsSensor = metrics.sensor("append-records");
        this.appendRecordsSensor.add(metrics.metricName("append-records-rate", metricGroupName, "The average number of records appended per sec as the leader of the raft quorum."), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new WindowedSum()));
        this.pollIdleSensor = metrics.sensor("poll-idle-ratio");
        this.pollIdleSensor.add(metrics.metricName("poll-idle-ratio-avg", metricGroupName, "The average fraction of time the client's poll() is idle as opposed to waiting for the user code to process records."), (MeasurableStat)new Avg());
    }

    public void updatePollStart(long currentTimeMs) {
        if (this.pollEndMs.isPresent() && this.pollStartMs.isPresent()) {
            long pollTimeMs = Math.max(this.pollEndMs.getAsLong() - this.pollStartMs.getAsLong(), 0L);
            long totalTimeMs = Math.max(currentTimeMs - this.pollStartMs.getAsLong(), 1L);
            this.pollIdleSensor.record((double)pollTimeMs / (double)totalTimeMs, currentTimeMs);
        }
        this.pollStartMs = OptionalLong.of(currentTimeMs);
        this.pollEndMs = OptionalLong.empty();
    }

    public void updatePollEnd(long currentTimeMs) {
        this.pollEndMs = OptionalLong.of(currentTimeMs);
    }

    public void updateLogEnd(OffsetAndEpoch logEndOffset) {
        this.logEndOffset = logEndOffset;
    }

    public void updateNumUnknownVoterConnections(int numUnknownVoterConnections) {
        this.numUnknownVoterConnections = numUnknownVoterConnections;
    }

    public void updateAppendRecords(long numRecords) {
        this.appendRecordsSensor.record((double)numRecords);
    }

    public void updateFetchedRecords(long numRecords) {
        this.fetchRecordsSensor.record((double)numRecords);
    }

    public void updateCommitLatency(double latencyMs, long currentTimeMs) {
        this.commitTimeSensor.record(latencyMs, currentTimeMs);
    }

    public void updateElectionStartMs(long currentTimeMs) {
        this.electionStartMs = OptionalLong.of(currentTimeMs);
    }

    public void maybeUpdateElectionLatency(long currentTimeMs) {
        if (this.electionStartMs.isPresent()) {
            this.electionTimeSensor.record((double)(currentTimeMs - this.electionStartMs.getAsLong()), currentTimeMs);
            this.electionStartMs = OptionalLong.empty();
        }
    }

    @Override
    public void close() {
        this.metrics.removeMetric(this.currentLeaderIdMetricName);
        this.metrics.removeMetric(this.currentVotedIdMetricName);
        this.metrics.removeMetric(this.currentEpochMetricName);
        this.metrics.removeMetric(this.currentStateMetricName);
        this.metrics.removeMetric(this.highWatermarkMetricName);
        this.metrics.removeMetric(this.logEndOffsetMetricName);
        this.metrics.removeMetric(this.logEndEpochMetricName);
        this.metrics.removeMetric(this.numUnknownVoterConnectionsMetricName);
        this.metrics.removeSensor(this.commitTimeSensor.name());
        this.metrics.removeSensor(this.electionTimeSensor.name());
        this.metrics.removeSensor(this.fetchRecordsSensor.name());
        this.metrics.removeSensor(this.appendRecordsSensor.name());
        this.metrics.removeSensor(this.pollIdleSensor.name());
    }
}

