/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.data;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionalComponentLifecycle;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.query.ReadWrite;

public class TransBlob
extends TransactionalComponentLifecycle<BlobState> {
    private final AtomicReference<ByteBuffer> blobRef = new AtomicReference();
    private final BufferChannel file;
    private boolean recoveryChange = false;

    public TransBlob(ComponentId cid, BufferChannel file) {
        super(cid);
        this.file = file;
        this.read();
    }

    private void read() {
        long x = this.file.size();
        ByteBuffer blob = ByteBuffer.allocate((int)x);
        int len = this.file.read(blob);
        if ((long)len != x) {
            throw new RuntimeIOException("Short read: " + len + " of " + x);
        }
        blob.rewind();
        this.blobRef.set(blob);
    }

    private void write() {
        ByteBuffer blob = this.blobRef.get();
        blob.rewind();
        int x = blob.remaining();
        this.file.truncate(0L);
        int len = this.file.write(blob);
        if (len != x) {
            throw new RuntimeIOException("Short write: " + len + " of " + x);
        }
        this.file.sync();
        blob.rewind();
    }

    public void setBlob(ByteBuffer bb) {
        this.requireWriteTxn();
        ((BlobState)this.getDataState()).setByteBuffer(bb);
    }

    public ByteBuffer getBlob() {
        if (this.isActiveTxn()) {
            return ((BlobState)this.getDataState()).getByteBuffer();
        }
        return this.blobRef.get();
    }

    public void setString(String dataStr) {
        this.requireWriteTxn();
        if (dataStr == null) {
            this.setBlob(null);
            return;
        }
        int maxNeeded = dataStr.length() * 4;
        ByteBuffer bb = ((BlobState)this.getDataState()).getByteBuffer();
        if (bb == this.blobRef.get()) {
            bb = ByteBuffer.allocate(maxNeeded);
        } else if (bb.capacity() >= maxNeeded) {
            bb.clear();
        } else {
            bb = ByteBuffer.allocate(maxNeeded);
        }
        Bytes.toByteBuffer((CharSequence)dataStr, (ByteBuffer)bb);
        bb.flip();
        this.setBlob(bb);
    }

    public String getString() {
        ByteBuffer bb = this.getBlob();
        if (bb == null) {
            return null;
        }
        int x = bb.position();
        String s = Bytes.fromByteBuffer((ByteBuffer)bb);
        bb.position(x);
        return s;
    }

    public void startRecovery() {
        this.recoveryChange = false;
    }

    public void recover(ByteBuffer ref) {
        this.blobRef.set(ref);
        this.recoveryChange = true;
    }

    public void finishRecovery() {
        if (this.recoveryChange) {
            this.write();
        }
    }

    public void cleanStart() {
    }

    protected BlobState _begin(ReadWrite readWrite, TxnId txnId) {
        return this.createState();
    }

    private BlobState createState() {
        ByteBuffer blob = this.blobRef.get();
        return new BlobState(blob);
    }

    protected BlobState _promote(TxnId txnId, BlobState state) {
        return this.createState();
    }

    protected ByteBuffer _commitPrepare(TxnId txnId, BlobState state) {
        if (!state.hasChanged) {
            return null;
        }
        return state.getByteBuffer();
    }

    protected void _commit(TxnId txnId, BlobState state) {
        if (!state.hasChanged) {
            return;
        }
        this.blobRef.set(state.getByteBuffer());
        this.write();
    }

    protected void _commitEnd(TxnId txnId, BlobState state) {
    }

    protected void _abort(TxnId txnId, BlobState state) {
    }

    protected void _complete(TxnId txnId, BlobState state) {
    }

    protected void _shutdown() {
    }

    public String toString() {
        return this.getComponentId().label();
    }

    static class BlobState {
        boolean hasChanged = false;
        ByteBuffer $txnBlob;

        BlobState(ByteBuffer bb) {
            this.setByteBuffer(bb);
        }

        void setByteBuffer(ByteBuffer bb) {
            this.$txnBlob = bb;
            this.hasChanged = true;
        }

        ByteBuffer getByteBuffer() {
            return this.$txnBlob;
        }
    }
}

