/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Mapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={LargeTests.class})
public class TestWALPlayer {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void beforeClass() throws Exception {
        cluster = TEST_UTIL.startMiniCluster();
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALPlayer() throws Exception {
        byte[] TABLENAME1 = Bytes.toBytes((String)"testWALPlayer1");
        byte[] TABLENAME2 = Bytes.toBytes((String)"testWALPlayer2");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] COLUMN2 = Bytes.toBytes((String)"c2");
        byte[] ROW = Bytes.toBytes((String)"row");
        HTable t1 = TEST_UTIL.createTable(TABLENAME1, FAMILY);
        HTable t2 = TEST_UTIL.createTable(TABLENAME2, FAMILY);
        Put p = new Put(ROW);
        p.add(FAMILY, COLUMN1, COLUMN1);
        p.add(FAMILY, COLUMN2, COLUMN2);
        t1.put(p);
        Delete d = new Delete(ROW);
        d.deleteColumns(FAMILY, COLUMN1);
        t1.delete(d);
        HLog log = cluster.getRegionServer(0).getWAL();
        log.rollWriter();
        String walInputDir = new Path(cluster.getMaster().getMasterFileSystem().getRootDir(), "WALs").toString();
        Configuration configuration = TEST_UTIL.getConfiguration();
        WALPlayer player = new WALPlayer(configuration);
        String optionName = "_test_.name";
        configuration.set(optionName, "1000");
        player.setupTime(configuration, optionName);
        Assert.assertEquals((long)1000L, (long)configuration.getLong(optionName, 0L));
        Assert.assertEquals((long)0L, (long)player.run(new String[]{walInputDir, Bytes.toString((byte[])TABLENAME1), Bytes.toString((byte[])TABLENAME2)}));
        Get g = new Get(ROW);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN2));
    }

    @Test
    public void testHLogKeyValueMapper() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set("hlog.input.tables", "table");
        WALPlayer.HLogKeyValueMapper mapper = new WALPlayer.HLogKeyValueMapper();
        HLogKey key = (HLogKey)Mockito.mock(HLogKey.class);
        Mockito.when((Object)key.getTablename()).thenReturn((Object)TableName.valueOf((String)"table"));
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)configuration);
        WALEdit value = (WALEdit)Mockito.mock(WALEdit.class);
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        KeyValue kv1 = (KeyValue)Mockito.mock(KeyValue.class);
        Mockito.when((Object)kv1.getFamily()).thenReturn((Object)Bytes.toBytes((String)"family"));
        Mockito.when((Object)kv1.getRow()).thenReturn((Object)Bytes.toBytes((String)"row"));
        values.add(kv1);
        Mockito.when((Object)value.getKeyValues()).thenReturn(values);
        mapper.setup(context);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                KeyValue key = (KeyValue)invocation.getArguments()[1];
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])key.getRow()));
                return null;
            }
        }).when((Object)context)).write(Matchers.any(ImmutableBytesWritable.class), Matchers.any(KeyValue.class));
        mapper.map(key, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                WALPlayer.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of arguments:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: WALPlayer [options] <wal inputdir> <tables> [<tableMappings>]"));
                Assert.assertTrue((boolean)data.toString().contains("-Dhlog.bulk.output=/path/for/output"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

