/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.policies;

import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.chaos.policies.Policy;
import org.apache.hadoop.hbase.util.Threads;

public abstract class PeriodicPolicy
extends Policy {
    private long periodMs;

    public PeriodicPolicy(long periodMs) {
        this.periodMs = periodMs;
    }

    @Override
    public void run() {
        int jitter = RandomUtils.nextInt((int)((int)this.periodMs));
        LOG.info((Object)("Sleeping for " + jitter + " to add jitter"));
        Threads.sleep((long)jitter);
        while (!this.isStopped()) {
            long start = System.currentTimeMillis();
            this.runOneIteration();
            if (this.isStopped()) {
                return;
            }
            long sleepTime = this.periodMs - (System.currentTimeMillis() - start);
            if (sleepTime <= 0L) continue;
            LOG.info((Object)("Sleeping for: " + sleepTime));
            Threads.sleep((long)sleepTime);
        }
    }

    protected abstract void runOneIteration();

    @Override
    public void init(Policy.PolicyContext context) throws Exception {
        super.init(context);
        LOG.info((Object)("Using ChaosMonkey Policy: " + this.getClass() + ", period: " + this.periodMs));
    }
}

