/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class TestUnixUserGroupInformation
extends TestCase {
    private static final String USER_NAME = "user1";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2", "group3"};

    public void testLogin() throws Exception {
        Configuration conf = new Configuration();
        String userName = UnixUserGroupInformation.getUnixUserName();
        UnixUserGroupInformation curUserGroupInfo = UnixUserGroupInformation.login((Configuration)conf);
        TestUnixUserGroupInformation.assertEquals((String)curUserGroupInfo.getUserName(), (String)userName);
        TestUnixUserGroupInformation.assertTrue((curUserGroupInfo == UnixUserGroupInformation.login((Configuration)conf) ? 1 : 0) != 0);
        UnixUserGroupInformation userGroupInfo = new UnixUserGroupInformation(USER_NAME, GROUP_NAMES);
        UnixUserGroupInformation.saveToConf((Configuration)conf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)userGroupInfo);
        curUserGroupInfo = UnixUserGroupInformation.login((Configuration)conf);
        TestUnixUserGroupInformation.assertEquals((Object)curUserGroupInfo, (Object)userGroupInfo);
        TestUnixUserGroupInformation.assertTrue((curUserGroupInfo == UnixUserGroupInformation.login((Configuration)conf) ? 1 : 0) != 0);
    }

    public void testConstructor() throws Exception {
        UnixUserGroupInformation uugi = new UnixUserGroupInformation(USER_NAME, GROUP_NAMES);
        TestUnixUserGroupInformation.assertEquals((Object)uugi, (Object)new UnixUserGroupInformation(new String[]{USER_NAME, GROUP1_NAME, GROUP2_NAME, GROUP3_NAME}));
        this.testConstructorFailures(null, GROUP_NAMES);
        this.testConstructorFailures("", GROUP_NAMES);
        this.testConstructorFailures(USER_NAME, null);
        this.testConstructorFailures(USER_NAME, new String[0]);
        this.testConstructorFailures(USER_NAME, new String[]{null});
        this.testConstructorFailures(USER_NAME, new String[]{""});
        this.testConstructorFailures(USER_NAME, new String[]{GROUP1_NAME, null});
        this.testConstructorFailures(USER_NAME, new String[]{GROUP1_NAME, null, GROUP2_NAME});
    }

    private void testConstructorFailures(String userName, String[] groupNames) {
        boolean gotException = false;
        try {
            new UnixUserGroupInformation(userName, groupNames);
        }
        catch (Exception e) {
            gotException = true;
        }
        TestUnixUserGroupInformation.assertTrue((boolean)gotException);
    }

    public void testEquals() throws Exception {
        UnixUserGroupInformation uugi = new UnixUserGroupInformation(USER_NAME, GROUP_NAMES);
        TestUnixUserGroupInformation.assertEquals((Object)uugi, (Object)uugi);
        TestUnixUserGroupInformation.assertEquals((Object)uugi, (Object)new UnixUserGroupInformation(USER_NAME, GROUP_NAMES));
        TestUnixUserGroupInformation.assertEquals((Object)uugi, (Object)new UnixUserGroupInformation(USER_NAME, new String[]{GROUP1_NAME, GROUP3_NAME, GROUP2_NAME}));
        TestUnixUserGroupInformation.assertFalse((boolean)uugi.equals((Object)new UnixUserGroupInformation()));
        TestUnixUserGroupInformation.assertFalse((boolean)uugi.equals((Object)new UnixUserGroupInformation(USER_NAME, new String[]{GROUP2_NAME, GROUP3_NAME, GROUP1_NAME})));
    }

    public void testWritable() throws Exception {
        UnixUserGroupInformation ugi = new UnixUserGroupInformation(USER_NAME, GROUP_NAMES);
        TestWritable.testWritable((Writable)ugi, new Configuration());
    }
}

