/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.mapred.DummyMemoryCalculatorPlugin;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobQueueTaskScheduler;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.util.LinuxMemoryCalculatorPlugin;
import org.apache.hadoop.util.MemoryCalculatorPlugin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestTTMemoryReporting
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestTTMemoryReporting.class);
    private MiniMRCluster miniMRCluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultMemoryValues() throws Exception {
        JobConf conf = new JobConf();
        try {
            conf.setClass("mapred.tasktracker.memory_calculator_plugin", DummyMemoryCalculatorPlugin.class, MemoryCalculatorPlugin.class);
            this.setUpCluster(conf);
            this.runSleepJob(this.miniMRCluster.createJobConf());
            this.verifyTestResults();
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfiguredMemoryValues() throws Exception {
        JobConf conf = new JobConf();
        conf.setLong("totalVmemOnTT", 0x100000000L);
        conf.setLong("totalPmemOnTT", 0x80000000L);
        conf.setLong("mapSlotMemorySize", 512L);
        conf.setLong("reduceSlotMemorySize", 1024L);
        conf.setClass("mapred.tasktracker.memory_calculator_plugin", DummyMemoryCalculatorPlugin.class, MemoryCalculatorPlugin.class);
        conf.setLong("mapred.tasktracker.maxvmem.testing", 0x100000000L);
        conf.setLong("mapred.tasktracker.maxpmem.testing", 0x80000000L);
        conf.setLong("mapred.cluster.map.memory.mb", 512L);
        conf.setLong("mapred.cluster.reduce.memory.mb", 1024L);
        try {
            this.setUpCluster(conf);
            JobConf jobConf = this.miniMRCluster.createJobConf();
            jobConf.setMemoryForMapTask(1024L);
            jobConf.setMemoryForReduceTask(2048L);
            this.runSleepJob(jobConf);
            this.verifyTestResults();
        }
        finally {
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryValuesOnLinux() throws Exception {
        if (!System.getProperty("os.name").startsWith("Linux")) {
            return;
        }
        JobConf conf = new JobConf();
        LinuxMemoryCalculatorPlugin plugin = new LinuxMemoryCalculatorPlugin();
        conf.setLong("totalVmemOnTT", plugin.getVirtualMemorySize());
        conf.setLong("totalPmemOnTT", plugin.getPhysicalMemorySize());
        try {
            this.setUpCluster(conf);
            this.runSleepJob(this.miniMRCluster.createJobConf());
            this.verifyTestResults();
        }
        finally {
            this.tearDownCluster();
        }
    }

    private void setUpCluster(JobConf conf) throws Exception {
        conf.setClass("mapred.jobtracker.taskScheduler", FakeTaskScheduler.class, TaskScheduler.class);
        conf.set("mapred.job.tracker.handler.count", "1");
        this.miniMRCluster = new MiniMRCluster(1, "file:///", 3, null, null, conf);
    }

    private void runSleepJob(JobConf conf) throws Exception {
        String[] args = new String[]{"-m", "1", "-r", "1", "-mt", "10", "-rt", "10"};
        ToolRunner.run((Configuration)conf, (Tool)new SleepJob(), (String[])args);
    }

    private void verifyTestResults() {
        FakeTaskScheduler scheduler = (FakeTaskScheduler)this.miniMRCluster.getJobTrackerRunner().getJobTracker().getTaskScheduler();
        TestTTMemoryReporting.assertTrue((String)scheduler.getFailureMessage(), (boolean)scheduler.hasTestPassed());
    }

    private void tearDownCluster() {
        if (this.miniMRCluster != null) {
            this.miniMRCluster.shutdown();
        }
    }

    public static class FakeTaskScheduler
    extends JobQueueTaskScheduler {
        private boolean hasPassed = true;
        private String message;

        public boolean hasTestPassed() {
            return this.hasPassed;
        }

        public String getFailureMessage() {
            return this.message;
        }

        public List<Task> assignTasks(TaskTrackerStatus status) throws IOException {
            long totalVirtualMemoryOnTT = this.getConf().getLong("totalVmemOnTT", -1L);
            long totalPhysicalMemoryOnTT = this.getConf().getLong("totalPmemOnTT", -1L);
            long mapSlotMemorySize = this.getConf().getLong("mapSlotMemorySize", -1L);
            long reduceSlotMemorySize = this.getConf().getLong("reduceSlotMemorySize", -1L);
            long reportedTotalVirtualMemoryOnTT = status.getResourceStatus().getTotalVirtualMemory();
            long reportedTotalPhysicalMemoryOnTT = status.getResourceStatus().getTotalPhysicalMemory();
            long reportedMapSlotMemorySize = status.getResourceStatus().getMapSlotMemorySizeOnTT();
            long reportedReduceSlotMemorySize = status.getResourceStatus().getReduceSlotMemorySizeOnTT();
            this.message = "expected memory values : (totalVirtualMemoryOnTT, totalPhysicalMemoryOnTT, mapSlotMemSize, reduceSlotMemorySize) = (" + totalVirtualMemoryOnTT + ", " + totalPhysicalMemoryOnTT + "," + mapSlotMemorySize + "," + reduceSlotMemorySize + ")";
            this.message = this.message + "\nreported memory values : (totalVirtualMemoryOnTT, totalPhysicalMemoryOnTT, reportedMapSlotMemorySize, reportedReduceSlotMemorySize) = (" + reportedTotalVirtualMemoryOnTT + ", " + reportedTotalPhysicalMemoryOnTT + "," + reportedMapSlotMemorySize + "," + reportedReduceSlotMemorySize + ")";
            LOG.info((Object)this.message);
            if (totalVirtualMemoryOnTT != reportedTotalVirtualMemoryOnTT || totalPhysicalMemoryOnTT != reportedTotalPhysicalMemoryOnTT || mapSlotMemorySize != reportedMapSlotMemorySize || reduceSlotMemorySize != reportedReduceSlotMemorySize) {
                this.hasPassed = false;
            }
            return super.assignTasks(status);
        }
    }
}

