/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueLineRecordReader;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;

public class TestKeyValueTextInputFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestKeyValueTextInputFormat.class.getName());
    private static int MAX_LENGTH = 10000;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        Path file = new Path(workDir, "test.txt");
        Reporter reporter = Reporter.NULL;
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
            try {
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            format.configure(job);
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 20) + 1;
                LOG.debug((Object)("splitting: requesting = " + numSplits));
                InputSplit[] splits = format.getSplits(job, numSplits);
                LOG.debug((Object)("splitting: got =        " + splits.length));
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits[j]));
                    RecordReader reader = format.getRecordReader(splits[j], job, reporter);
                    Class<?> readerClass = reader.getClass();
                    TestKeyValueTextInputFormat.assertEquals((String)"reader class is KeyValueLineRecordReader.", KeyValueLineRecordReader.class, readerClass);
                    Text key = (Text)reader.createKey();
                    Class<?> keyClass = key.getClass();
                    Text value = (Text)reader.createValue();
                    Class<?> valueClass = value.getClass();
                    TestKeyValueTextInputFormat.assertEquals((String)"Key class is Text.", Text.class, keyClass);
                    TestKeyValueTextInputFormat.assertEquals((String)"Value class is Text.", Text.class, valueClass);
                    try {
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int v = Integer.parseInt(value.toString());
                            LOG.debug((Object)("read " + v));
                            if (bits.get(v)) {
                                LOG.warn((Object)("conflict with " + v + " in split " + j + " at position " + reader.getPos()));
                            }
                            TestKeyValueTextInputFormat.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits[j] + " count=" + count));
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                TestKeyValueTextInputFormat.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), (Configuration)defaultConf);
    }

    public void testUTF8() throws Exception {
        LineReader in = this.makeStream("abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        TestKeyValueTextInputFormat.assertEquals((String)"readLine changed utf8 characters", (String)"abcd\u20acbdcd\u20ac", (String)line.toString());
        in = this.makeStream("abc\u200axyz");
        in.readLine(line);
        TestKeyValueTextInputFormat.assertEquals((String)"split on fake newline", (String)"abc\u200axyz", (String)line.toString());
    }

    public void testNewLines() throws Exception {
        LineReader in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
        Text out = new Text();
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line1 length", (int)1, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line2 length", (int)2, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line3 length", (int)0, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line4 length", (int)3, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line5 length", (int)4, (int)out.getLength());
        in.readLine(out);
        TestKeyValueTextInputFormat.assertEquals((String)"line5 length", (int)5, (int)out.getLength());
        TestKeyValueTextInputFormat.assertEquals((String)"end of file", (int)0, (int)in.readLine(out));
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.getRecordReader(split, job, voidReporter);
        Text key = (Text)reader.createKey();
        Text value = (Text)reader.createValue();
        while (reader.next((Object)key, (Object)value)) {
            result.add(value);
            value = (Text)reader.createValue();
        }
        return result;
    }

    public static void testGzip() throws IOException {
        JobConf job = new JobConf();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "line-1\tthis is a test\nline-1\tof gzip\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        TestKeyValueTextInputFormat.assertEquals((String)"compressed splits == 2", (int)2, (int)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestKeyValueTextInputFormat.readSplit(format, splits[0], job);
        TestKeyValueTextInputFormat.assertEquals((String)"splits[0] length", (int)6, (int)results.size());
        TestKeyValueTextInputFormat.assertEquals((String)"splits[0][5]", (String)" dog", (String)results.get(5).toString());
        results = TestKeyValueTextInputFormat.readSplit(format, splits[1], job);
        TestKeyValueTextInputFormat.assertEquals((String)"splits[1] length", (int)2, (int)results.size());
        TestKeyValueTextInputFormat.assertEquals((String)"splits[1][0]", (String)"this is a test", (String)results.get(0).toString());
        TestKeyValueTextInputFormat.assertEquals((String)"splits[1][1]", (String)"of gzip", (String)results.get(1).toString());
    }

    public static void main(String[] args) throws Exception {
        new TestKeyValueTextInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
        voidReporter = Reporter.NULL;
    }
}

