/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;

public class TestJobKillAndFail
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJobFailAndKill() throws IOException {
        MiniMRCluster mr = null;
        try {
            mr = new MiniMRCluster(2, "file:///", 3);
            JobConf conf = mr.createJobConf();
            Path inDir = new Path(TEST_ROOT_DIR + "/failkilljob/input");
            Path outDir = new Path(TEST_ROOT_DIR + "/failkilljob/output");
            RunningJob job = UtilsForTests.runJobFail(conf, inDir, outDir);
            TestJobKillAndFail.assertEquals((int)job.getJobState(), (int)3);
            job = UtilsForTests.runJobKill(conf, inDir, outDir);
            TestJobKillAndFail.assertTrue((boolean)job.isComplete());
            TestJobKillAndFail.assertEquals((int)job.getJobState(), (int)5);
        }
        finally {
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

