/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class TestFileInputFormat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocality() throws Exception {
        JobConf conf = new JobConf();
        MiniDFSCluster dfs = null;
        try {
            dfs = new MiniDFSCluster((Configuration)conf, 4, true, new String[]{"/rack0", "/rack0", "/rack1", "/rack1"}, new String[]{"host0", "host1", "host2", "host3"});
            FileSystem fs = dfs.getFileSystem();
            System.out.println("FileSystem " + fs.getUri());
            Path path = new Path("/foo/bar");
            FSDataOutputStream out = fs.create(path, true, 4096, (short)2, 512L, null);
            for (int i = 0; i < 1000; ++i) {
                out.writeChars("Hello\n");
            }
            out.close();
            System.out.println("Wrote file");
            TextInputFormat.addInputPath((JobConf)conf, (Path)path);
            TextInputFormat inFormat = new TextInputFormat();
            inFormat.configure(conf);
            InputSplit[] splits = inFormat.getSplits(conf, 1);
            FileStatus fileStatus = fs.getFileStatus(path);
            BlockLocation[] locations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            System.out.println("Made splits");
            for (int i = 0; i < splits.length; ++i) {
                FileSplit fileSplit = (FileSplit)splits[i];
                System.out.println("File split: " + fileSplit);
                for (String h : fileSplit.getLocations()) {
                    System.out.println("Location: " + h);
                }
                System.out.println("Block: " + locations[i]);
                TestFileInputFormat.assertEquals((long)locations[i].getOffset(), (long)fileSplit.getStart());
                TestFileInputFormat.assertEquals((long)locations[i].getLength(), (long)fileSplit.getLength());
                String[] blockLocs = locations[i].getHosts();
                String[] splitLocs = fileSplit.getLocations();
                TestFileInputFormat.assertEquals((int)2, (int)blockLocs.length);
                TestFileInputFormat.assertEquals((int)2, (int)splitLocs.length);
                TestFileInputFormat.assertTrue((blockLocs[0].equals(splitLocs[0]) && blockLocs[1].equals(splitLocs[1]) || blockLocs[1].equals(splitLocs[0]) && blockLocs[0].equals(splitLocs[1]) ? 1 : 0) != 0);
            }
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
        }
    }
}

