/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TestMapOutputType;

public class TestComparators
extends TestCase {
    JobConf conf = new JobConf(TestMapOutputType.class);
    JobClient jc;
    static Random rng = new Random();

    public void configure() throws Exception {
        Path testdir = new Path("build/test/test.mapred.spill");
        Path inDir = new Path(testdir, "in");
        Path outDir = new Path(testdir, "out");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(testdir, true);
        this.conf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outDir);
        this.conf.setOutputKeyClass(IntWritable.class);
        this.conf.setOutputValueClass(Text.class);
        this.conf.setMapOutputValueClass(IntWritable.class);
        this.conf.setNumMapTasks(2);
        this.conf.setOutputFormat(SequenceFileOutputFormat.class);
        if (!fs.mkdirs(testdir)) {
            throw new IOException("Mkdirs failed to create " + testdir.toString());
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        Path inFile = new Path(inDir, "part0");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)inFile, IntWritable.class, IntWritable.class);
        writer.append((Writable)new IntWritable(11), (Writable)new IntWritable(999));
        writer.append((Writable)new IntWritable(23), (Writable)new IntWritable(456));
        writer.append((Writable)new IntWritable(10), (Writable)new IntWritable(780));
        writer.close();
        inFile = new Path(inDir, "part1");
        writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)inFile, IntWritable.class, IntWritable.class);
        writer.append((Writable)new IntWritable(45), (Writable)new IntWritable(100));
        writer.append((Writable)new IntWritable(18), (Writable)new IntWritable(200));
        writer.append((Writable)new IntWritable(27), (Writable)new IntWritable(300));
        writer.close();
        this.jc = new JobClient(this.conf);
    }

    public void testDefaultMRComparator() throws Exception {
        this.configure();
        this.conf.setMapperClass(IdentityMapper.class);
        this.conf.setReducerClass(AscendingKeysReducer.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testUserMRComparator() throws Exception {
        this.configure();
        this.conf.setMapperClass(IdentityMapper.class);
        this.conf.setReducerClass(DescendingKeysReducer.class);
        this.conf.setOutputKeyComparatorClass(DecreasingIntComparator.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testUserValueGroupingComparator() throws Exception {
        this.configure();
        this.conf.setMapperClass(RandomGenMapper.class);
        this.conf.setReducerClass(AscendingGroupReducer.class);
        this.conf.setOutputValueGroupingComparator(CompositeIntGroupFn.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testAllUserComparators() throws Exception {
        this.configure();
        this.conf.setMapperClass(RandomGenMapper.class);
        this.conf.setOutputKeyComparatorClass(DecreasingIntComparator.class);
        this.conf.setReducerClass(DescendingGroupReducer.class);
        this.conf.setOutputValueGroupingComparator(CompositeIntReverseGroupFn.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testBakedUserComparator() throws Exception {
        MyWritable a = new MyWritable(8, 8);
        MyWritable b = new MyWritable(7, 9);
        TestComparators.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        TestComparators.assertTrue((WritableComparator.get(MyWritable.class).compare((WritableComparable)a, (WritableComparable)b) < 0 ? 1 : 0) != 0);
    }

    public static class MyCmp
    extends WritableComparator {
        public MyCmp() {
            super(MyWritable.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            MyWritable aa = (MyWritable)a;
            MyWritable bb = (MyWritable)b;
            return aa.j - bb.j;
        }
    }

    public static class MyWritable
    implements WritableComparable<MyWritable> {
        int i;
        int j;

        public MyWritable() {
        }

        public MyWritable(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public void readFields(DataInput in) throws IOException {
            this.i = in.readInt();
            this.j = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.i);
            out.writeInt(this.j);
        }

        public int compareTo(MyWritable b) {
            return this.i - b.i;
        }

        static {
            WritableComparator.define(MyWritable.class, (WritableComparator)new MyCmp());
        }
    }

    public static class CompositeIntReverseGroupFn
    extends CompositeIntGroupFn {
        @Override
        public int compare(WritableComparable v1, WritableComparable v2) {
            return -super.compare(v1, v2);
        }

        @Override
        public boolean equals(IntWritable v1, IntWritable v2) {
            return !super.equals(v1, v2);
        }

        static {
            WritableComparator.define(CompositeIntReverseGroupFn.class, (WritableComparator)new BooleanWritable.Comparator());
        }
    }

    public static class CompositeIntGroupFn
    extends WritableComparator {
        public CompositeIntGroupFn() {
            super(IntWritable.class);
        }

        public int compare(WritableComparable v1, WritableComparable v2) {
            int val2;
            int val1 = ((IntWritable)v1).get() / 100;
            if (val1 < (val2 = ((IntWritable)v2).get() / 100)) {
                return 1;
            }
            if (val1 > val2) {
                return -1;
            }
            return 0;
        }

        public boolean equals(IntWritable v1, IntWritable v2) {
            int val2;
            int val1 = v1.get();
            return val1 / 100 == (val2 = v2.get()) / 100;
        }

        static {
            WritableComparator.define(CompositeIntGroupFn.class, (WritableComparator)new BooleanWritable.Comparator());
        }
    }

    public static class DecreasingIntComparator
    extends IntWritable.Comparator {
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return -super.compare(b1, s1, l1, b2, s2, l2);
        }

        static {
            WritableComparator.define(DecreasingIntComparator.class, (WritableComparator)new BooleanWritable.Comparator());
        }
    }

    static class DescendingGroupReducer
    implements Reducer<IntWritable, IntWritable, IntWritable, Text> {
        private int lastKey = Integer.MAX_VALUE;

        DescendingGroupReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> values, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            int currentKey = key.get();
            if (currentKey > this.lastKey) {
                Assert.fail((String)"Keys not in sorted descending order");
            }
            this.lastKey = currentKey;
            IntWritable previous = new IntWritable(Integer.MAX_VALUE);
            int valueCount = 0;
            while (values.hasNext()) {
                IntWritable current = values.next();
                if (current.compareTo((Object)previous) > 0) {
                    Assert.fail((String)"Values generated by Mapper not in order");
                }
                previous = current;
                ++valueCount;
            }
            if (valueCount != 5) {
                Assert.fail((String)"Values not grouped by primary key");
            }
            out.collect((Object)key, (Object)new Text("success"));
        }

        public void close() {
        }
    }

    static class AscendingGroupReducer
    implements Reducer<IntWritable, IntWritable, IntWritable, Text> {
        private int lastKey = Integer.MIN_VALUE;

        AscendingGroupReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<IntWritable> values, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            int currentKey = key.get();
            if (currentKey < this.lastKey) {
                Assert.fail((String)"Keys not in sorted ascending order");
            }
            this.lastKey = currentKey;
            IntWritable previous = new IntWritable(Integer.MIN_VALUE);
            int valueCount = 0;
            while (values.hasNext()) {
                IntWritable current = values.next();
                if (current.compareTo((Object)previous) < 0) {
                    Assert.fail((String)"Values generated by Mapper not in order");
                }
                previous = current;
                ++valueCount;
            }
            if (valueCount != 5) {
                Assert.fail((String)"Values not grouped by primary key");
            }
            out.collect((Object)key, (Object)new Text("success"));
        }

        public void close() {
        }
    }

    static class DescendingKeysReducer
    implements Reducer<IntWritable, Writable, IntWritable, Text> {
        private int lastKey = Integer.MAX_VALUE;

        DescendingKeysReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<Writable> values, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            int currentKey = key.get();
            if (currentKey > this.lastKey) {
                Assert.fail((String)"Keys not in sorted descending order");
            }
            this.lastKey = currentKey;
            out.collect((Object)key, (Object)new Text("success"));
        }

        public void close() {
        }
    }

    static class AscendingKeysReducer
    implements Reducer<IntWritable, Writable, IntWritable, Text> {
        private int lastKey = Integer.MIN_VALUE;

        AscendingKeysReducer() {
        }

        public void configure(JobConf job) {
        }

        public void reduce(IntWritable key, Iterator<Writable> values, OutputCollector<IntWritable, Text> out, Reporter reporter) throws IOException {
            int currentKey = key.get();
            if (currentKey < this.lastKey) {
                Assert.fail((String)"Keys not in sorted ascending order");
            }
            this.lastKey = currentKey;
            out.collect((Object)key, (Object)new Text("success"));
        }

        public void close() {
        }
    }

    static class IdentityMapper
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        IdentityMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            out.collect((Object)key, (Object)value);
        }

        public void close() {
        }
    }

    static class RandomGenMapper
    implements Mapper<IntWritable, Writable, IntWritable, IntWritable> {
        RandomGenMapper() {
        }

        public void configure(JobConf job) {
        }

        public void map(IntWritable key, Writable value, OutputCollector<IntWritable, IntWritable> out, Reporter reporter) throws IOException {
            int num_values = 5;
            for (int i = 0; i < num_values; ++i) {
                int val = rng.nextInt(num_values);
                int compositeKey = key.get() * 100 + val;
                out.collect((Object)new IntWritable(compositeKey), (Object)new IntWritable(val));
            }
        }

        public void close() {
        }
    }
}

