/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.MiniMRCluster;

public class TestSocketFactory
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSocketFactory() throws IOException {
        Configuration sconf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(sconf, 1, true, null);
        int nameNodePort = cluster.getNameNodePort();
        FileSystem fs = cluster.getFileSystem();
        TestSocketFactory.assertTrue((boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem directDfs = (DistributedFileSystem)fs;
        Configuration cconf = new Configuration();
        FileSystem.setDefaultUri((Configuration)cconf, (String)String.format("hdfs://localhost:%s/", nameNodePort + 10));
        cconf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.ipc.DummySocketFactory");
        cconf.set("hadoop.rpc.socket.factory.class.ClientProtocol", "org.apache.hadoop.ipc.DummySocketFactory");
        cconf.set("hadoop.rpc.socket.factory.class.JobSubmissionProtocol", "org.apache.hadoop.ipc.DummySocketFactory");
        fs = FileSystem.get((Configuration)cconf);
        TestSocketFactory.assertTrue((boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        JobClient client = null;
        MiniMRCluster mr = null;
        try {
            Path filePath = new Path("/dir");
            TestSocketFactory.assertFalse((boolean)directDfs.exists(filePath));
            TestSocketFactory.assertFalse((boolean)dfs.exists(filePath));
            directDfs.mkdirs(filePath);
            TestSocketFactory.assertTrue((boolean)directDfs.exists(filePath));
            TestSocketFactory.assertTrue((boolean)dfs.exists(filePath));
            fs = FileSystem.get((Configuration)sconf);
            mr = new MiniMRCluster(1, fs.getUri().toString(), 1);
            int jobTrackerPort = mr.getJobTrackerPort();
            JobConf jconf = new JobConf(cconf);
            jconf.set("mapred.job.tracker", String.format("localhost:%d", jobTrackerPort + 10));
            client = new JobClient(jconf);
            JobStatus[] jobs = client.jobsToComplete();
            TestSocketFactory.assertTrue((jobs.length == 0 ? 1 : 0) != 0);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            try {
                if (dfs != null) {
                    dfs.close();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            try {
                if (directDfs != null) {
                    directDfs.close();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            try {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            if (mr != null) {
                try {
                    mr.shutdown();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
    }
}

