/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.Utils;

public class TestVLong
extends TestCase {
    private static String ROOT = System.getProperty("test.build.data", "/tmp/tfile-test");
    private Configuration conf;
    private FileSystem fs;
    private Path path;
    private String outputFile = "TestVLong";

    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        if (this.fs.exists(this.path)) {
            this.fs.delete(this.path, false);
        }
    }

    public void tearDown() throws IOException {
        if (this.fs.exists(this.path)) {
            this.fs.delete(this.path, false);
        }
    }

    public void testVLongByte() throws IOException {
        FSDataOutputStream out = this.fs.create(this.path);
        for (int i = -128; i <= 127; ++i) {
            Utils.writeVLong((DataOutput)out, (long)i);
        }
        out.close();
        Assert.assertEquals((String)"Incorrect encoded size", (long)352L, (long)this.fs.getFileStatus(this.path).getLen());
        FSDataInputStream in = this.fs.open(this.path);
        for (int i = -128; i <= 127; ++i) {
            long n = Utils.readVLong((DataInput)in);
            Assert.assertEquals((long)n, (long)i);
        }
        in.close();
        this.fs.delete(this.path, false);
    }

    private long writeAndVerify(int shift) throws IOException {
        FSDataOutputStream out = this.fs.create(this.path);
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            Utils.writeVLong((DataOutput)out, (long)((long)i << shift));
        }
        out.close();
        FSDataInputStream in = this.fs.open(this.path);
        for (int i = Short.MIN_VALUE; i <= Short.MAX_VALUE; ++i) {
            long n = Utils.readVLong((DataInput)in);
            Assert.assertEquals((long)n, (long)((long)i << shift));
        }
        in.close();
        long ret = this.fs.getFileStatus(this.path).getLen();
        this.fs.delete(this.path, false);
        return ret;
    }

    public void testVLongShort() throws IOException {
        long size = this.writeAndVerify(0);
        Assert.assertEquals((String)"Incorrect encoded size", (long)186208L, (long)size);
    }

    public void testVLong3Bytes() throws IOException {
        long size = this.writeAndVerify(8);
        Assert.assertEquals((String)"Incorrect encoded size", (long)253911L, (long)size);
    }

    public void testVLong4Bytes() throws IOException {
        long size = this.writeAndVerify(16);
        Assert.assertEquals((String)"Incorrect encoded size", (long)323550L, (long)size);
    }

    public void testVLong5Bytes() throws IOException {
        long size = this.writeAndVerify(24);
        Assert.assertEquals((String)"Incorrect encoded size", (long)392941L, (long)size);
    }

    private void verifySixOrMoreBytes(int bytes) throws IOException {
        long size = this.writeAndVerify(8 * (bytes - 2));
        Assert.assertEquals((String)"Incorrect encoded size", (long)(65536 * (bytes + 1) - 256 - bytes + 1), (long)size);
    }

    public void testVLong6Bytes() throws IOException {
        this.verifySixOrMoreBytes(6);
    }

    public void testVLong7Bytes() throws IOException {
        this.verifySixOrMoreBytes(7);
    }

    public void testVLong8Bytes() throws IOException {
        this.verifySixOrMoreBytes(8);
    }

    public void testVLongRandom() throws IOException {
        int count = 0x100000;
        long[] data = new long[count];
        Random rng = new Random();
        for (int i = 0; i < data.length; ++i) {
            int shift = rng.nextInt(64) + 1;
            long mask = (1L << shift) - 1L;
            long a = rng.nextInt() << 32;
            long b = (long)rng.nextInt() & 0xFFFFFFFFFFFFFFFFL;
            data[i] = a + b & mask;
        }
        FSDataOutputStream out = this.fs.create(this.path);
        for (int i = 0; i < data.length; ++i) {
            Utils.writeVLong((DataOutput)out, (long)data[i]);
        }
        out.close();
        FSDataInputStream in = this.fs.open(this.path);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)Utils.readVLong((DataInput)in), (long)data[i]);
        }
        in.close();
        this.fs.delete(this.path, false);
    }
}

