/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import junit.framework.TestCase;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;

public class TestBytesWritable
extends TestCase {
    public void testSizeChange() throws Exception {
        byte[] hadoop = "hadoop".getBytes();
        BytesWritable buf = new BytesWritable(hadoop);
        int size = buf.getLength();
        int orig_capacity = buf.getCapacity();
        buf.setSize(size * 2);
        int new_capacity = buf.getCapacity();
        System.arraycopy(buf.getBytes(), 0, buf.getBytes(), size, size);
        TestBytesWritable.assertTrue((new_capacity >= size * 2 ? 1 : 0) != 0);
        TestBytesWritable.assertEquals((int)(size * 2), (int)buf.getLength());
        TestBytesWritable.assertTrue((new_capacity != orig_capacity ? 1 : 0) != 0);
        buf.setSize(size * 4);
        TestBytesWritable.assertTrue((new_capacity != buf.getCapacity() ? 1 : 0) != 0);
        for (int i = 0; i < size * 2; ++i) {
            TestBytesWritable.assertEquals((byte)hadoop[i % size], (byte)buf.getBytes()[i]);
        }
        buf.setCapacity(1);
        TestBytesWritable.assertEquals((int)1, (int)buf.getLength());
        TestBytesWritable.assertEquals((byte)hadoop[0], (byte)buf.getBytes()[0]);
    }

    public void testHash() throws Exception {
        byte[] owen = "owen".getBytes();
        BytesWritable buf = new BytesWritable(owen);
        TestBytesWritable.assertEquals((int)4347922, (int)buf.hashCode());
        buf.setCapacity(10000);
        TestBytesWritable.assertEquals((int)4347922, (int)buf.hashCode());
        buf.setSize(0);
        TestBytesWritable.assertEquals((int)1, (int)buf.hashCode());
    }

    public void testCompare() throws Exception {
        int i;
        byte[][] values = new byte[][]{"abc".getBytes(), "ad".getBytes(), "abcd".getBytes(), "".getBytes(), "b".getBytes()};
        BytesWritable[] buf = new BytesWritable[values.length];
        for (i = 0; i < values.length; ++i) {
            buf[i] = new BytesWritable(values[i]);
        }
        for (i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                TestBytesWritable.assertTrue((buf[i].compareTo((BinaryComparable)buf[j]) == -buf[j].compareTo((BinaryComparable)buf[i]) ? 1 : 0) != 0);
                TestBytesWritable.assertTrue((i == j == (buf[i].compareTo((BinaryComparable)buf[j]) == 0) ? 1 : 0) != 0);
            }
        }
        TestBytesWritable.assertTrue((buf[0].compareTo((BinaryComparable)buf[1]) < 0 ? 1 : 0) != 0);
        TestBytesWritable.assertTrue((buf[1].compareTo((BinaryComparable)buf[2]) > 0 ? 1 : 0) != 0);
        TestBytesWritable.assertTrue((buf[2].compareTo((BinaryComparable)buf[3]) > 0 ? 1 : 0) != 0);
        TestBytesWritable.assertTrue((buf[3].compareTo((BinaryComparable)buf[4]) < 0 ? 1 : 0) != 0);
    }

    private void checkToString(byte[] input, String expected) {
        String actual = new BytesWritable(input).toString();
        TestBytesWritable.assertEquals((String)expected, (String)actual);
    }

    public void testToString() {
        this.checkToString(new byte[]{0, 1, 2, 16}, "00 01 02 10");
        this.checkToString(new byte[]{-128, -127, -1, -2, 1, 0}, "80 81 ff fe 01 00");
    }
}

