/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;

public class TestNameEditsConfigs
extends TestCase {
    static final long SEED = 3735928559L;
    static final int BLOCK_SIZE = 4096;
    static final int FILE_SIZE = 8192;
    static final int NUM_DATA_NODES = 3;
    static final String FILE_IMAGE = "current/fsimage";
    static final String FILE_EDITS = "current/edits";
    short replication = (short)3;
    private File base_dir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");

    protected void setUp() throws Exception {
        if (this.base_dir.exists()) {
            this.tearDown();
        }
    }

    protected void tearDown() throws Exception {
        if (!FileUtil.fullyDelete((File)this.base_dir)) {
            throw new IOException("Cannot remove directory " + this.base_dir);
        }
    }

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    void checkImageAndEditsFilesExistence(File dir, boolean imageMustExist, boolean editsMustExist) {
        TestNameEditsConfigs.assertTrue((imageMustExist == new File(dir, FILE_IMAGE).exists() ? 1 : 0) != 0);
        TestNameEditsConfigs.assertTrue((editsMustExist == new File(dir, FILE_EDITS).exists() ? 1 : 0) != 0);
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(name));
        short replication = fileSys.getFileStatus(name).getReplication();
        TestNameEditsConfigs.assertEquals((String)("replication for " + name), (int)repl, (int)replication);
        long size = fileSys.getContentSummary(name).getLength();
        TestNameEditsConfigs.assertEquals((String)("file size for " + name), (long)size, (long)8192L);
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestNameEditsConfigs.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    SecondaryNameNode startSecondaryNameNode(Configuration conf) throws IOException {
        conf.set("dfs.secondary.http.address", "0.0.0.0:0");
        return new SecondaryNameNode(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNameEditsConfigs() throws IOException {
        Path file1 = new Path("TestNameEditsConfigs1");
        Path file2 = new Path("TestNameEditsConfigs2");
        Path file3 = new Path("TestNameEditsConfigs3");
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        Configuration conf = null;
        FileSystem fileSys = null;
        File newNameDir = new File(this.base_dir, "name");
        File newEditsDir = new File(this.base_dir, "edits");
        File nameAndEdits = new File(this.base_dir, "name_and_edits");
        File checkpointNameDir = new File(this.base_dir, "secondname");
        File checkpointEditsDir = new File(this.base_dir, "secondedits");
        File checkpointNameAndEdits = new File(this.base_dir, "second_name_and_edits");
        conf = new Configuration();
        conf.set("dfs.name.dir", nameAndEdits.getPath());
        conf.set("dfs.name.edits.dir", nameAndEdits.getPath());
        conf.set("fs.checkpoint.dir", checkpointNameAndEdits.getPath());
        conf.set("fs.checkpoint.edits.dir", checkpointNameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, true, false, true, null, null, null, null);
        cluster.waitActive();
        secondary = this.startSecondaryNameNode(conf);
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            this.writeFile(fileSys, file1, this.replication);
            this.checkFile(fileSys, file1, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        conf = new Configuration();
        TestNameEditsConfigs.assertTrue((boolean)newNameDir.mkdir());
        TestNameEditsConfigs.assertTrue((boolean)newEditsDir.mkdir());
        conf.set("dfs.name.dir", nameAndEdits.getPath() + "," + newNameDir.getPath());
        conf.set("dfs.name.edits.dir", nameAndEdits.getPath() + "," + newEditsDir.getPath());
        conf.set("fs.checkpoint.dir", checkpointNameDir.getPath() + "," + checkpointNameAndEdits.getPath());
        conf.set("fs.checkpoint.edits.dir", checkpointEditsDir.getPath() + "," + checkpointNameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
        cluster.waitActive();
        secondary = this.startSecondaryNameNode(conf);
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(file1));
            this.checkFile(fileSys, file1, this.replication);
            this.cleanupFile(fileSys, file1);
            this.writeFile(fileSys, file2, this.replication);
            this.checkFile(fileSys, file2, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        this.checkImageAndEditsFilesExistence(nameAndEdits, true, true);
        this.checkImageAndEditsFilesExistence(newNameDir, true, false);
        this.checkImageAndEditsFilesExistence(newEditsDir, false, true);
        this.checkImageAndEditsFilesExistence(checkpointNameAndEdits, true, true);
        this.checkImageAndEditsFilesExistence(checkpointNameDir, true, false);
        this.checkImageAndEditsFilesExistence(checkpointEditsDir, false, true);
        new File(nameAndEdits, FILE_EDITS).renameTo(new File(newNameDir, FILE_EDITS));
        new File(nameAndEdits, FILE_IMAGE).renameTo(new File(newEditsDir, FILE_IMAGE));
        new File(checkpointNameAndEdits, FILE_EDITS).renameTo(new File(checkpointNameDir, FILE_EDITS));
        new File(checkpointNameAndEdits, FILE_IMAGE).renameTo(new File(checkpointEditsDir, FILE_IMAGE));
        conf = new Configuration();
        conf.set("dfs.name.dir", newNameDir.getPath());
        conf.set("dfs.name.edits.dir", newEditsDir.getPath());
        conf.set("fs.checkpoint.dir", checkpointNameDir.getPath());
        conf.set("fs.checkpoint.edits.dir", checkpointEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
        cluster.waitActive();
        secondary = this.startSecondaryNameNode(conf);
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(file2));
            this.checkFile(fileSys, file2, this.replication);
            this.cleanupFile(fileSys, file2);
            this.writeFile(fileSys, file3, this.replication);
            this.checkFile(fileSys, file3, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        this.checkImageAndEditsFilesExistence(newNameDir, true, false);
        this.checkImageAndEditsFilesExistence(newEditsDir, false, true);
        this.checkImageAndEditsFilesExistence(checkpointNameDir, true, false);
        this.checkImageAndEditsFilesExistence(checkpointEditsDir, false, true);
        TestNameEditsConfigs.assertTrue((boolean)FileUtil.fullyDelete((File)new File(nameAndEdits, "current")));
        TestNameEditsConfigs.assertTrue((boolean)FileUtil.fullyDelete((File)new File(checkpointNameAndEdits, "current")));
        conf = new Configuration();
        conf.set("dfs.name.dir", nameAndEdits.getPath() + "," + newNameDir.getPath());
        conf.set("dfs.name.edits.dir", nameAndEdits + "," + newEditsDir.getPath());
        conf.set("fs.checkpoint.dir", checkpointNameDir.getPath() + "," + checkpointNameAndEdits.getPath());
        conf.set("fs.checkpoint.edits.dir", checkpointEditsDir.getPath() + "," + checkpointNameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
        cluster.waitActive();
        secondary = this.startSecondaryNameNode(conf);
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestNameEditsConfigs.assertTrue((!fileSys.exists(file2) ? 1 : 0) != 0);
            TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(file3));
            this.checkFile(fileSys, file3, this.replication);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            secondary.shutdown();
        }
        this.checkImageAndEditsFilesExistence(nameAndEdits, true, true);
        this.checkImageAndEditsFilesExistence(checkpointNameAndEdits, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNameEditsConfigsFailure() throws IOException {
        Path file1 = new Path("TestNameEditsConfigs1");
        Path file2 = new Path("TestNameEditsConfigs2");
        Path file3 = new Path("TestNameEditsConfigs3");
        MiniDFSCluster cluster = null;
        Configuration conf = null;
        FileSystem fileSys = null;
        File newNameDir = new File(this.base_dir, "name");
        File newEditsDir = new File(this.base_dir, "edits");
        File nameAndEdits = new File(this.base_dir, "name_and_edits");
        conf = new Configuration();
        conf.set("dfs.name.dir", nameAndEdits.getPath());
        conf.set("dfs.name.edits.dir", nameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, true, false, true, null, null, null, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            this.writeFile(fileSys, file1, this.replication);
            this.checkFile(fileSys, file1, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        conf = new Configuration();
        TestNameEditsConfigs.assertTrue((boolean)newNameDir.mkdir());
        TestNameEditsConfigs.assertTrue((boolean)newEditsDir.mkdir());
        conf.set("dfs.name.dir", nameAndEdits.getPath() + "," + newNameDir.getPath());
        conf.set("dfs.name.edits.dir", nameAndEdits.getPath() + "," + newEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(file1));
            this.checkFile(fileSys, file1, this.replication);
            this.cleanupFile(fileSys, file1);
            this.writeFile(fileSys, file2, this.replication);
            this.checkFile(fileSys, file2, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        conf = new Configuration();
        conf.set("dfs.name.dir", newNameDir.getPath());
        conf.set("dfs.name.edits.dir", newEditsDir.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        try {
            TestNameEditsConfigs.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestNameEditsConfigs.assertTrue((boolean)fileSys.exists(file2));
            this.checkFile(fileSys, file2, this.replication);
            this.cleanupFile(fileSys, file2);
            this.writeFile(fileSys, file3, this.replication);
            this.checkFile(fileSys, file3, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        conf = new Configuration();
        conf.set("dfs.name.dir", newNameDir.getPath() + "," + nameAndEdits.getPath());
        conf.set("dfs.name.edits.dir", nameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        try {
            cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
            TestNameEditsConfigs.assertTrue((boolean)false);
        }
        catch (IOException e) {
            System.out.println("cluster start failed due to missing latest edits dir");
        }
        finally {
            cluster = null;
        }
        conf = new Configuration();
        conf.set("dfs.name.dir", nameAndEdits.getPath());
        conf.set("dfs.name.edits.dir", newEditsDir.getPath() + "," + nameAndEdits.getPath());
        this.replication = (short)conf.getInt("dfs.replication", 3);
        try {
            cluster = new MiniDFSCluster(0, conf, 3, false, false, true, null, null, null, null);
            TestNameEditsConfigs.assertTrue((boolean)false);
        }
        catch (IOException e) {
            System.out.println("cluster start failed due to missing latest name dir");
        }
        finally {
            cluster = null;
        }
    }
}

