/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;

public class TestHeartbeatHandling
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHeartbeat() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 1, true, null);
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
            DatanodeRegistration nodeReg = cluster.getDataNodes().get((int)0).dnRegistration;
            DatanodeDescriptor dd = namesystem.getDatanode((DatanodeID)nodeReg);
            boolean REMAINING_BLOCKS = true;
            int MAX_REPLICATE_LIMIT = conf.getInt("dfs.max-repl-streams", 2);
            int MAX_INVALIDATE_LIMIT = 100;
            int MAX_INVALIDATE_BLOCKS = 201;
            int MAX_REPLICATE_BLOCKS = 2 * MAX_REPLICATE_LIMIT + 1;
            DatanodeDescriptor[] ONE_TARGET = new DatanodeDescriptor[1];
            ArrayList arrayList = namesystem.heartbeats;
            synchronized (arrayList) {
                for (int i = 0; i < MAX_REPLICATE_BLOCKS; ++i) {
                    dd.addBlockToBeReplicated(new Block((long)i, 0L, 1000L), ONE_TARGET);
                }
                DatanodeCommand[] cmds = namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), 0, 0);
                TestHeartbeatHandling.assertEquals((int)1, (int)cmds.length);
                TestHeartbeatHandling.assertEquals((int)1, (int)cmds[0].getAction());
                TestHeartbeatHandling.assertEquals((int)MAX_REPLICATE_LIMIT, (int)((BlockCommand)cmds[0]).getBlocks().length);
                ArrayList<Block> blockList = new ArrayList<Block>(201);
                for (int i = 0; i < 201; ++i) {
                    blockList.add(new Block((long)i, 0L, 1000L));
                }
                dd.addBlocksToBeInvalidated(blockList);
                cmds = namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), 0, 0);
                TestHeartbeatHandling.assertEquals((int)2, (int)cmds.length);
                TestHeartbeatHandling.assertEquals((int)1, (int)cmds[0].getAction());
                TestHeartbeatHandling.assertEquals((int)MAX_REPLICATE_LIMIT, (int)((BlockCommand)cmds[0]).getBlocks().length);
                TestHeartbeatHandling.assertEquals((int)2, (int)cmds[1].getAction());
                TestHeartbeatHandling.assertEquals((int)100, (int)((BlockCommand)cmds[1]).getBlocks().length);
                cmds = namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), 0, 0);
                TestHeartbeatHandling.assertEquals((int)2, (int)cmds.length);
                TestHeartbeatHandling.assertEquals((int)1, (int)cmds[0].getAction());
                TestHeartbeatHandling.assertEquals((int)1, (int)((BlockCommand)cmds[0]).getBlocks().length);
                TestHeartbeatHandling.assertEquals((int)2, (int)cmds[1].getAction());
                TestHeartbeatHandling.assertEquals((int)100, (int)((BlockCommand)cmds[1]).getBlocks().length);
                cmds = namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), 0, 0);
                TestHeartbeatHandling.assertEquals((int)1, (int)cmds.length);
                TestHeartbeatHandling.assertEquals((int)2, (int)cmds[0].getAction());
                TestHeartbeatHandling.assertEquals((int)1, (int)((BlockCommand)cmds[0]).getBlocks().length);
                cmds = namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), 0, 0);
                TestHeartbeatHandling.assertEquals(null, (Object)cmds);
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

