/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileNameGenerator;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;

public class NNThroughputBenchmark {
    private static final Log LOG = LogFactory.getLog(NNThroughputBenchmark.class);
    private static final int BLOCK_SIZE = 16;
    static Configuration config;
    static NameNode nameNode;
    private final UserGroupInformation ugi;

    NNThroughputBenchmark(Configuration conf) throws IOException, LoginException {
        config = conf;
        this.ugi = UnixUserGroupInformation.login((Configuration)config);
        UserGroupInformation.setCurrentUser((UserGroupInformation)this.ugi);
        config.setInt("dfs.namenode.handler.count", 1);
        config.set("dfs.hosts.exclude", "${hadoop.tmp.dir}/dfs/hosts/exclude");
        File excludeFile = new File(config.get("dfs.hosts.exclude", "exclude"));
        if (!excludeFile.exists() && !excludeFile.getParentFile().mkdirs()) {
            throw new IOException("NNThroughputBenchmark: cannot mkdir " + excludeFile);
        }
        new FileOutputStream(excludeFile).close();
        String[] argv = new String[]{};
        nameNode = NameNode.createNameNode((String[])argv, (Configuration)config);
    }

    void close() throws IOException {
        nameNode.stop();
    }

    static void turnOffNameNodeLogging() {
        ((Log4JLogger)NameNode.LOG).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)NetworkTopology.LOG).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)FSNamesystem.LOG).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)FSNamesystem.auditLog).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ERROR);
    }

    static void printUsage() {
        System.err.println("Usage: NNThroughputBenchmark\n\t-op all <other ops options> [-keepResults] | \n\t-op create [-threads T] [-files N] [-filesPerDir P] [-close] | \n\t-op open [-threads T] [-files N] [-filesPerDir P] [-useExisting] | \n\t-op delete [-threads T] [-files N] [-filesPerDir P] [-useExisting] | \n\t-op rename [-threads T] [-files N] [-filesPerDir P] [-useExisting] | \n\t-op blockReport [-datanodes T] [-reports N] [-blocksPerReport B] [-blocksPerFile F] | \n\t-op replication [-datanodes T] [-nodesToDecommission D] [-nodeReplicationLimit C] [-totalBlocks B] [-replication R] | \n\t-op clean");
        System.exit(-1);
    }

    public static void runBenchmark(Configuration conf, List<String> args) throws Exception {
        if (args.size() < 2 || !args.get(0).startsWith("-op")) {
            NNThroughputBenchmark.printUsage();
        }
        String type = args.get(1);
        boolean runAll = "all".equals(type);
        NNThroughputBenchmark bench = null;
        ArrayList<CreateFileStats> ops = new ArrayList<CreateFileStats>();
        OperationStatsBase opStat = null;
        try {
            bench = new NNThroughputBenchmark(conf);
            if (runAll || "create".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new CreateFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "open".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new OpenFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "delete".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new DeleteFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "rename".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new RenameFileStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "blockReport".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new BlockReportStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "replication".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new ReplicationStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (runAll || "clean".equals(type)) {
                NNThroughputBenchmark nNThroughputBenchmark = bench;
                nNThroughputBenchmark.getClass();
                opStat = nNThroughputBenchmark.new CleanAllStats(args);
                ops.add((CreateFileStats)opStat);
            }
            if (ops.size() == 0) {
                NNThroughputBenchmark.printUsage();
            }
            for (OperationStatsBase operationStatsBase : ops) {
                LOG.info((Object)("Starting benchmark: " + operationStatsBase.getOpName()));
                operationStatsBase.benchmark();
                operationStatsBase.cleanUp();
            }
            for (OperationStatsBase operationStatsBase : ops) {
                LOG.info((Object)"");
                operationStatsBase.printResults();
            }
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        finally {
            if (bench != null) {
                bench.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        NNThroughputBenchmark.runBenchmark(new Configuration(), new ArrayList<String>(Arrays.asList(args)));
    }

    class ReplicationStats
    extends OperationStatsBase {
        static final String OP_REPLICATION_NAME = "replication";
        static final String OP_REPLICATION_USAGE = "-op replication [-datanodes T] [-nodesToDecommission D] [-nodeReplicationLimit C] [-totalBlocks B] [-replication R]";
        private BlockReportStats blockReportObject;
        private int numDatanodes;
        private int nodesToDecommission;
        private int nodeReplicationLimit;
        private int totalBlocks;
        private int numDecommissionedBlocks;
        private int numPendingBlocks;

        ReplicationStats(List<String> args) {
            this.numThreads = 1;
            this.numDatanodes = 3;
            this.nodesToDecommission = 1;
            this.nodeReplicationLimit = 100;
            this.totalBlocks = 100;
            this.parseArguments(args);
            this.numOpsRequired = this.totalBlocks * this.replication * this.nodesToDecommission * 2 / (this.numDatanodes * this.numDatanodes);
            String[] blkReportArgs = new String[]{"-op", "blockReport", "-datanodes", String.valueOf(this.numDatanodes), "-blocksPerReport", String.valueOf(this.totalBlocks * this.replication / this.numDatanodes), "-blocksPerFile", String.valueOf(this.numDatanodes)};
            this.blockReportObject = new BlockReportStats(Arrays.asList(blkReportArgs));
            this.numDecommissionedBlocks = 0;
            this.numPendingBlocks = 0;
        }

        @Override
        String getOpName() {
            return OP_REPLICATION_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-datanodes")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numDatanodes = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-nodesToDecommission")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.nodesToDecommission = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-nodeReplicationLimit")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.nodeReplicationLimit = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-totalBlocks")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.totalBlocks = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-replication")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.replication = Short.parseShort(args.get(++i));
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
        }

        @Override
        void generateInputs(int[] ignore) throws IOException {
            this.blockReportObject.generateInputs(ignore);
            NNThroughputBenchmark.nameNode.namesystem.replthread.interrupt();
            try {
                NNThroughputBenchmark.nameNode.namesystem.replthread.join();
            }
            catch (InterruptedException ei) {
                return;
            }
            int nrDatanodes = this.blockReportObject.getNumDatanodes();
            for (int idx = 0; idx < nrDatanodes; ++idx) {
                this.blockReportObject.executeOp(idx, 0, null);
            }
            this.decommissionNodes();
            NNThroughputBenchmark.nameNode.namesystem.setNodeReplicationLimit(this.nodeReplicationLimit);
        }

        private void decommissionNodes() throws IOException {
            String excludeFN = config.get("dfs.hosts.exclude", "exclude");
            FileOutputStream excludeFile = new FileOutputStream(excludeFN);
            excludeFile.getChannel().truncate(0L);
            int nrDatanodes = this.blockReportObject.getNumDatanodes();
            this.numDecommissionedBlocks = 0;
            for (int i = 0; i < this.nodesToDecommission; ++i) {
                TinyDatanode dn = this.blockReportObject.datanodes[nrDatanodes - 1 - i];
                this.numDecommissionedBlocks += dn.nrBlocks;
                excludeFile.write(dn.getName().getBytes());
                excludeFile.write(10);
                LOG.info((Object)("Datanode " + dn.getName() + " is decommissioned."));
            }
            excludeFile.close();
            nameNode.refreshNodes();
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return null;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            assert (daemonId < this.numThreads) : "Wrong daemonId.";
            long start = System.currentTimeMillis();
            int work = NNThroughputBenchmark.nameNode.namesystem.computeDatanodeWork();
            long end = System.currentTimeMillis();
            this.numPendingBlocks += work;
            if (work == 0) {
                ((StatsDaemon)this.daemons.get(daemonId)).terminate();
            }
            return end - start;
        }

        @Override
        void printResults() {
            String blockDistribution = "";
            String delim = "(";
            int totalReplicas = 0;
            for (int idx = 0; idx < this.blockReportObject.getNumDatanodes(); ++idx) {
                totalReplicas += ((BlockReportStats)this.blockReportObject).datanodes[idx].nrBlocks;
                blockDistribution = blockDistribution + delim + ((BlockReportStats)this.blockReportObject).datanodes[idx].nrBlocks;
                delim = ", ";
            }
            blockDistribution = blockDistribution + ")";
            LOG.info((Object)("--- " + this.getOpName() + " inputs ---"));
            LOG.info((Object)("numOpsRequired = " + this.numOpsRequired));
            LOG.info((Object)("datanodes = " + this.numDatanodes + " " + blockDistribution));
            LOG.info((Object)("decommissioned datanodes = " + this.nodesToDecommission));
            LOG.info((Object)("datanode replication limit = " + this.nodeReplicationLimit));
            LOG.info((Object)("total blocks = " + this.totalBlocks));
            this.printStats();
            LOG.info((Object)("decommissioned blocks = " + this.numDecommissionedBlocks));
            LOG.info((Object)("pending replications = " + this.numPendingBlocks));
            LOG.info((Object)("replications per sec: " + this.getBlocksPerSecond()));
        }

        private double getBlocksPerSecond() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.numPendingBlocks / (double)this.elapsedTime;
        }
    }

    class BlockReportStats
    extends OperationStatsBase {
        static final String OP_BLOCK_REPORT_NAME = "blockReport";
        static final String OP_BLOCK_REPORT_USAGE = "-op blockReport [-datanodes T] [-reports N] [-blocksPerReport B] [-blocksPerFile F]";
        private int blocksPerReport;
        private int blocksPerFile;
        private TinyDatanode[] datanodes;

        BlockReportStats(List<String> args) {
            this.blocksPerReport = 100;
            this.blocksPerFile = 10;
            config.setLong("dfs.heartbeat.interval", 180L);
            this.parseArguments(args);
            this.replication = (short)Math.min(this.replication, this.getNumDatanodes());
        }

        private int getNumDatanodes() {
            return this.numThreads;
        }

        @Override
        String getOpName() {
            return OP_BLOCK_REPORT_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-reports")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numOpsRequired = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-datanodes")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numThreads = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blocksPerReport")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blocksPerReport = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-blocksPerFile")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.blocksPerFile = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
        }

        @Override
        void generateInputs(int[] ignore) throws IOException {
            int idx;
            int nrDatanodes = this.getNumDatanodes();
            int nrBlocks = (int)Math.ceil((double)this.blocksPerReport * (double)nrDatanodes / (double)this.replication);
            int nrFiles = (int)Math.ceil((double)nrBlocks / (double)this.blocksPerFile);
            this.datanodes = new TinyDatanode[nrDatanodes];
            String prevDNName = "";
            for (int idx2 = 0; idx2 < nrDatanodes; ++idx2) {
                this.datanodes[idx2] = new TinyDatanode(idx2, this.blocksPerReport);
                this.datanodes[idx2].register();
                assert (this.datanodes[idx2].getName().compareTo(prevDNName) > 0) : "Data-nodes must be sorted lexicographically.";
                this.datanodes[idx2].sendHeartbeat();
                prevDNName = this.datanodes[idx2].getName();
            }
            LOG.info((Object)("Creating " + nrFiles + " with " + this.blocksPerFile + " blocks each."));
            FileNameGenerator nameGenerator = new FileNameGenerator(this.getBaseDir(), 100);
            String clientName = this.getClientName(7);
            nameNode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            for (idx = 0; idx < nrFiles; ++idx) {
                String fileName = nameGenerator.getNextFileName("ThroughputBench");
                nameNode.create(fileName, FsPermission.getDefault(), clientName, true, this.replication, 16L);
                this.addBlocks(fileName, clientName);
                nameNode.complete(fileName, clientName);
            }
            for (idx = 0; idx < nrDatanodes; ++idx) {
                this.datanodes[idx].formBlockReport();
            }
        }

        private void addBlocks(String fileName, String clientName) throws IOException {
            for (int jdx = 0; jdx < this.blocksPerFile; ++jdx) {
                LocatedBlock loc = nameNode.addBlock(fileName, clientName);
                for (DatanodeInfo dnInfo : loc.getLocations()) {
                    int dnIdx = Arrays.binarySearch(this.datanodes, dnInfo.getName());
                    this.datanodes[dnIdx].addBlock(loc.getBlock());
                    nameNode.blockReceived(this.datanodes[dnIdx].dnRegistration, new Block[]{loc.getBlock()}, new String[]{""});
                }
            }
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return null;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            assert (daemonId < this.numThreads) : "Wrong daemonId.";
            TinyDatanode dn = this.datanodes[daemonId];
            long start = System.currentTimeMillis();
            nameNode.blockReport(dn.dnRegistration, BlockListAsLongs.convertToArrayLongs((Block[])dn.blocks));
            long end = System.currentTimeMillis();
            return end - start;
        }

        @Override
        void printResults() {
            String blockDistribution = "";
            String delim = "(";
            for (int idx = 0; idx < this.getNumDatanodes(); ++idx) {
                blockDistribution = blockDistribution + delim + this.datanodes[idx].nrBlocks;
                delim = ", ";
            }
            blockDistribution = blockDistribution + ")";
            LOG.info((Object)("--- " + this.getOpName() + " inputs ---"));
            LOG.info((Object)("reports = " + this.numOpsRequired));
            LOG.info((Object)("datanodes = " + this.numThreads + " " + blockDistribution));
            LOG.info((Object)("blocksPerReport = " + this.blocksPerReport));
            LOG.info((Object)("blocksPerFile = " + this.blocksPerFile));
            this.printStats();
        }
    }

    private static class TinyDatanode
    implements Comparable<String> {
        private static final long DF_CAPACITY = 0x6400000L;
        private static final long DF_USED = 0L;
        NamespaceInfo nsInfo;
        DatanodeRegistration dnRegistration;
        Block[] blocks;
        int nrBlocks;

        private static String getNodeName(int port) throws IOException {
            String machineName = DNS.getDefaultHost((String)"default", (String)"default");
            String sPort = String.valueOf(100000 + port);
            if (sPort.length() > 6) {
                throw new IOException("Too many data-nodes.");
            }
            return machineName + ":" + sPort;
        }

        TinyDatanode(int dnIdx, int blockCapacity) throws IOException {
            this.dnRegistration = new DatanodeRegistration(TinyDatanode.getNodeName(dnIdx));
            this.blocks = new Block[blockCapacity];
            this.nrBlocks = 0;
        }

        String getName() {
            return this.dnRegistration.getName();
        }

        void register() throws IOException {
            this.nsInfo = nameNode.versionRequest();
            this.dnRegistration.setStorageInfo(new DataStorage((StorageInfo)this.nsInfo, ""));
            DataNode.setNewStorageID((DatanodeRegistration)this.dnRegistration);
            this.dnRegistration = nameNode.register(this.dnRegistration);
        }

        void sendHeartbeat() throws IOException {
            DatanodeCommand[] cmds = nameNode.sendHeartbeat(this.dnRegistration, 0x6400000L, 0L, 0x6400000L, 0, 0);
            if (cmds != null) {
                for (DatanodeCommand cmd : cmds) {
                    LOG.debug((Object)("sendHeartbeat Name-node reply: " + cmd.getAction()));
                }
            }
        }

        boolean addBlock(Block blk) {
            if (this.nrBlocks == this.blocks.length) {
                LOG.debug((Object)("Cannot add block: datanode capacity = " + this.blocks.length));
                return false;
            }
            this.blocks[this.nrBlocks] = blk;
            ++this.nrBlocks;
            return true;
        }

        void formBlockReport() {
            for (int idx = this.blocks.length - 1; idx >= this.nrBlocks; --idx) {
                this.blocks[idx] = new Block((long)(this.blocks.length - idx), 0L, 0L);
            }
        }

        @Override
        public int compareTo(String name) {
            return this.getName().compareTo(name);
        }

        int replicateBlocks() throws IOException {
            DatanodeCommand[] cmds = nameNode.sendHeartbeat(this.dnRegistration, 0x6400000L, 0L, 0x6400000L, 0, 0);
            if (cmds != null) {
                for (DatanodeCommand cmd : cmds) {
                    if (cmd.getAction() != 1) continue;
                    BlockCommand bcmd = (BlockCommand)cmd;
                    return this.transferBlocks(bcmd.getBlocks(), bcmd.getTargets());
                }
            }
            return 0;
        }

        private int transferBlocks(Block[] blocks, DatanodeInfo[][] xferTargets) throws IOException {
            for (int i = 0; i < blocks.length; ++i) {
                DatanodeInfo[] blockTargets = xferTargets[i];
                for (int t = 0; t < blockTargets.length; ++t) {
                    DatanodeInfo dnInfo = blockTargets[t];
                    DatanodeRegistration receivedDNReg = new DatanodeRegistration(dnInfo.getName());
                    receivedDNReg.setStorageInfo(new DataStorage((StorageInfo)this.nsInfo, dnInfo.getStorageID()));
                    receivedDNReg.setInfoPort(dnInfo.getInfoPort());
                    nameNode.blockReceived(receivedDNReg, new Block[]{blocks[i]}, new String[]{""});
                }
            }
            return blocks.length;
        }
    }

    class RenameFileStats
    extends OpenFileStats {
        static final String OP_RENAME_NAME = "rename";
        static final String OP_RENAME_USAGE = "-op rename [-threads T] [-files N] [-filesPerDir P] [-useExisting]";
        protected String[][] destNames;

        RenameFileStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_RENAME_NAME;
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            super.generateInputs(opsPerThread);
            this.destNames = new String[this.fileNames.length][];
            for (int idx = 0; idx < this.numThreads; ++idx) {
                int nrNames = this.fileNames[idx].length;
                this.destNames[idx] = new String[nrNames];
                for (int jdx = 0; jdx < nrNames; ++jdx) {
                    this.destNames[idx][jdx] = this.fileNames[idx][jdx] + ".r";
                }
            }
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = System.currentTimeMillis();
            nameNode.rename(this.fileNames[daemonId][inputIdx], this.destNames[daemonId][inputIdx]);
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    class DeleteFileStats
    extends OpenFileStats {
        static final String OP_DELETE_NAME = "delete";
        static final String OP_DELETE_USAGE = "-op delete [-threads T] [-files N] [-filesPerDir P] [-useExisting]";

        DeleteFileStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_DELETE_NAME;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = System.currentTimeMillis();
            nameNode.delete(this.fileNames[daemonId][inputIdx], false);
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    class OpenFileStats
    extends CreateFileStats {
        static final String OP_OPEN_NAME = "open";
        static final String OP_USAGE_ARGS = " [-threads T] [-files N] [-filesPerDir P] [-useExisting]";
        static final String OP_OPEN_USAGE = "-op open [-threads T] [-files N] [-filesPerDir P] [-useExisting]";
        private boolean useExisting;

        OpenFileStats(List<String> args) {
            super(args);
        }

        @Override
        String getOpName() {
            return OP_OPEN_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            int ueIndex = args.indexOf("-useExisting");
            boolean bl = this.useExisting = ueIndex >= 0;
            if (this.useExisting) {
                args.remove(ueIndex);
            }
            super.parseArguments(args);
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            String[] createArgs = new String[]{"-op", "create", "-threads", String.valueOf(this.numThreads), "-files", String.valueOf(this.numOpsRequired), "-filesPerDir", String.valueOf(this.nameGenerator.getFilesPerDirectory()), "-close"};
            CreateFileStats opCreate = new CreateFileStats(Arrays.asList(createArgs));
            if (!this.useExisting) {
                opCreate.benchmark();
                LOG.info((Object)("Created " + this.numOpsRequired + " files."));
            } else {
                LOG.info((Object)("useExisting = true. Assuming " + this.numOpsRequired + " files have been created before."));
            }
            super.generateInputs(opsPerThread);
            if (nameNode.getFileInfo(opCreate.getBaseDir()) != null && nameNode.getFileInfo(this.getBaseDir()) == null) {
                nameNode.rename(opCreate.getBaseDir(), this.getBaseDir());
            }
            if (nameNode.getFileInfo(this.getBaseDir()) == null) {
                throw new IOException(this.getBaseDir() + " does not exist.");
            }
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            long start = System.currentTimeMillis();
            nameNode.getBlockLocations(this.fileNames[daemonId][inputIdx], 0L, 16L);
            long end = System.currentTimeMillis();
            return end - start;
        }
    }

    class CreateFileStats
    extends OperationStatsBase {
        static final String OP_CREATE_NAME = "create";
        static final String OP_CREATE_USAGE = "-op create [-threads T] [-files N] [-filesPerDir P] [-close]";
        protected FileNameGenerator nameGenerator;
        protected String[][] fileNames;
        private boolean closeUponCreate;

        CreateFileStats(List<String> args) {
            this.parseArguments(args);
        }

        @Override
        String getOpName() {
            return OP_CREATE_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            int nrFilesPerDir = 4;
            this.closeUponCreate = false;
            for (int i = 2; i < args.size(); ++i) {
                if (args.get(i).equals("-files")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numOpsRequired = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-threads")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    this.numThreads = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-filesPerDir")) {
                    if (i + 1 == args.size()) {
                        NNThroughputBenchmark.printUsage();
                    }
                    nrFilesPerDir = Integer.parseInt(args.get(++i));
                    continue;
                }
                if (args.get(i).equals("-close")) {
                    this.closeUponCreate = true;
                    continue;
                }
                if (ignoreUnrelatedOptions) continue;
                NNThroughputBenchmark.printUsage();
            }
            this.nameGenerator = new FileNameGenerator(this.getBaseDir(), nrFilesPerDir);
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
            assert (opsPerThread.length == this.numThreads) : "Error opsPerThread.length";
            nameNode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            LOG.info((Object)("Generate " + this.numOpsRequired + " intputs for " + this.getOpName()));
            this.fileNames = new String[this.numThreads][];
            for (int idx = 0; idx < this.numThreads; ++idx) {
                int threadOps = opsPerThread[idx];
                this.fileNames[idx] = new String[threadOps];
                for (int jdx = 0; jdx < threadOps; ++jdx) {
                    this.fileNames[idx][jdx] = this.nameGenerator.getNextFileName("ThroughputBench");
                }
            }
        }

        void dummyActionNoSynch(int daemonId, int fileIdx) {
            for (int i = 0; i < 2000; ++i) {
                this.fileNames[daemonId][fileIdx].contains("" + i);
            }
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return this.getClientName(daemonId);
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String clientName) throws IOException {
            boolean written;
            long start = System.currentTimeMillis();
            nameNode.create(this.fileNames[daemonId][inputIdx], FsPermission.getDefault(), clientName, true, this.replication, 16L);
            long end = System.currentTimeMillis();
            boolean bl = written = !this.closeUponCreate;
            while (!written) {
                written = nameNode.complete(this.fileNames[daemonId][inputIdx], clientName);
            }
            return end - start;
        }

        @Override
        void printResults() {
            LOG.info((Object)("--- " + this.getOpName() + " inputs ---"));
            LOG.info((Object)("nrFiles = " + this.numOpsRequired));
            LOG.info((Object)("nrThreads = " + this.numThreads));
            LOG.info((Object)("nrFilesPerDir = " + this.nameGenerator.getFilesPerDirectory()));
            this.printStats();
        }
    }

    class CleanAllStats
    extends OperationStatsBase {
        static final String OP_CLEAN_NAME = "clean";
        static final String OP_CLEAN_USAGE = "-op clean";

        CleanAllStats(List<String> args) {
            this.parseArguments(args);
            this.numOpsRequired = 1;
            this.numThreads = 1;
            this.keepResults = true;
        }

        @Override
        String getOpName() {
            return OP_CLEAN_NAME;
        }

        @Override
        void parseArguments(List<String> args) {
            boolean ignoreUnrelatedOptions = this.verifyOpArgument(args);
            if (args.size() > 2 && !ignoreUnrelatedOptions) {
                NNThroughputBenchmark.printUsage();
            }
        }

        @Override
        void generateInputs(int[] opsPerThread) throws IOException {
        }

        @Override
        String getExecutionArgument(int daemonId) {
            return null;
        }

        @Override
        long executeOp(int daemonId, int inputIdx, String ignore) throws IOException {
            nameNode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            long start = System.currentTimeMillis();
            nameNode.delete("/nnThroughputBenchmark", true);
            long end = System.currentTimeMillis();
            return end - start;
        }

        @Override
        void printResults() {
            LOG.info((Object)("--- " + this.getOpName() + " inputs ---"));
            LOG.info((Object)"Remove directory /nnThroughputBenchmark");
            this.printStats();
        }
    }

    private class StatsDaemon
    extends Thread {
        private int daemonId;
        private int opsPerThread;
        private String arg1;
        private volatile int localNumOpsExecuted = 0;
        private volatile long localCumulativeTime = 0L;
        private OperationStatsBase statsOp;

        StatsDaemon(int daemonId, int nrOps, OperationStatsBase op) {
            this.daemonId = daemonId;
            this.opsPerThread = nrOps;
            this.statsOp = op;
            this.setName(this.toString());
        }

        @Override
        public void run() {
            UserGroupInformation.setCurrentUser((UserGroupInformation)NNThroughputBenchmark.this.ugi);
            this.localNumOpsExecuted = 0;
            this.localCumulativeTime = 0L;
            this.arg1 = this.statsOp.getExecutionArgument(this.daemonId);
            try {
                this.benchmarkOne();
            }
            catch (IOException ex) {
                LOG.error((Object)("StatsDaemon " + this.daemonId + " failed: \n" + StringUtils.stringifyException((Throwable)ex)));
            }
        }

        @Override
        public String toString() {
            return "StatsDaemon-" + this.daemonId;
        }

        void benchmarkOne() throws IOException {
            for (int idx = 0; idx < this.opsPerThread; ++idx) {
                long stat = this.statsOp.executeOp(this.daemonId, idx, this.arg1);
                ++this.localNumOpsExecuted;
                this.localCumulativeTime += stat;
            }
        }

        boolean isInProgress() {
            return this.localNumOpsExecuted < this.opsPerThread;
        }

        void terminate() {
            this.opsPerThread = this.localNumOpsExecuted;
        }
    }

    abstract class OperationStatsBase {
        protected static final String BASE_DIR_NAME = "/nnThroughputBenchmark";
        protected static final String OP_ALL_NAME = "all";
        protected static final String OP_ALL_USAGE = "-op all <other ops options> [-keepResults]";
        protected String baseDir = "/nnThroughputBenchmark/" + this.getOpName();
        protected short replication = (short)config.getInt("dfs.replication", 3);
        protected int numThreads = 3;
        protected int numOpsRequired = 10;
        protected int numOpsExecuted = 0;
        protected long cumulativeTime = 0L;
        protected long elapsedTime = 0L;
        protected boolean keepResults = false;
        protected List<StatsDaemon> daemons;

        abstract String getOpName();

        abstract void parseArguments(List<String> var1) throws IOException;

        abstract void generateInputs(int[] var1) throws IOException;

        abstract String getExecutionArgument(int var1);

        abstract long executeOp(int var1, int var2, String var3) throws IOException;

        abstract void printResults();

        OperationStatsBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void benchmark() throws IOException {
            this.daemons = new ArrayList<StatsDaemon>();
            long start = 0L;
            try {
                this.numOpsExecuted = 0;
                this.cumulativeTime = 0L;
                if (this.numThreads < 1) {
                    return;
                }
                int tIdx = 0;
                int[] opsPerThread = new int[this.numThreads];
                for (int opsScheduled = 0; opsScheduled < this.numOpsRequired; opsScheduled += opsPerThread[tIdx++]) {
                    opsPerThread[tIdx] = (this.numOpsRequired - opsScheduled) / (this.numThreads - tIdx);
                    if (opsPerThread[tIdx] != 0) continue;
                    opsPerThread[tIdx] = 1;
                }
                while (tIdx < this.numThreads) {
                    opsPerThread[tIdx] = 0;
                    ++tIdx;
                }
                NNThroughputBenchmark.turnOffNameNodeLogging();
                this.generateInputs(opsPerThread);
                for (tIdx = 0; tIdx < this.numThreads; ++tIdx) {
                    this.daemons.add(new StatsDaemon(tIdx, opsPerThread[tIdx], this));
                }
                start = System.currentTimeMillis();
                LOG.info((Object)("Starting " + this.numOpsRequired + " " + this.getOpName() + "(s)."));
                for (StatsDaemon d : this.daemons) {
                    d.start();
                }
            }
            finally {
                while (this.isInPorgress()) {
                }
                this.elapsedTime = System.currentTimeMillis() - start;
                for (StatsDaemon d : this.daemons) {
                    this.incrementStats(d.localNumOpsExecuted, d.localCumulativeTime);
                }
            }
        }

        private boolean isInPorgress() {
            for (StatsDaemon d : this.daemons) {
                if (!d.isInProgress()) continue;
                return true;
            }
            return false;
        }

        void cleanUp() throws IOException {
            nameNode.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_LEAVE);
            if (!this.keepResults) {
                nameNode.delete(this.getBaseDir(), true);
            }
        }

        int getNumOpsExecuted() {
            return this.numOpsExecuted;
        }

        long getCumulativeTime() {
            return this.cumulativeTime;
        }

        long getElapsedTime() {
            return this.elapsedTime;
        }

        long getAverageTime() {
            return this.numOpsExecuted == 0 ? 0L : this.cumulativeTime / (long)this.numOpsExecuted;
        }

        double getOpsPerSecond() {
            return this.elapsedTime == 0L ? 0.0 : 1000.0 * (double)this.numOpsExecuted / (double)this.elapsedTime;
        }

        String getBaseDir() {
            return this.baseDir;
        }

        String getClientName(int idx) {
            return this.getOpName() + "-client-" + idx;
        }

        void incrementStats(int ops, long time) {
            this.numOpsExecuted += ops;
            this.cumulativeTime += time;
        }

        protected boolean verifyOpArgument(List<String> args) {
            String type;
            int krIndex;
            if (args.size() < 2 || !args.get(0).startsWith("-op")) {
                NNThroughputBenchmark.printUsage();
            }
            boolean bl = this.keepResults = (krIndex = args.indexOf("-keepResults")) >= 0;
            if (this.keepResults) {
                args.remove(krIndex);
            }
            if (OP_ALL_NAME.equals(type = args.get(1))) {
                type = this.getOpName();
                return true;
            }
            if (!this.getOpName().equals(type)) {
                NNThroughputBenchmark.printUsage();
            }
            return false;
        }

        void printStats() {
            LOG.info((Object)("--- " + this.getOpName() + " stats  ---"));
            LOG.info((Object)("# operations: " + this.getNumOpsExecuted()));
            LOG.info((Object)("Elapsed Time: " + this.getElapsedTime()));
            LOG.info((Object)(" Ops per sec: " + this.getOpsPerSecond()));
            LOG.info((Object)("Average Time: " + this.getAverageTime()));
        }
    }
}

