/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import junit.framework.TestCase;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

public class TestFsPermission
extends TestCase {
    public void testFsAction() {
        for (FsAction a : FsAction.values()) {
            TestFsPermission.assertTrue((boolean)FsAction.ALL.implies(a));
        }
        for (FsAction a : FsAction.values()) {
            TestFsPermission.assertTrue((boolean)(a == FsAction.NONE ? FsAction.NONE.implies(a) : !FsAction.NONE.implies(a)));
        }
        for (FsAction a : FsAction.values()) {
            TestFsPermission.assertTrue((boolean)(a == FsAction.READ_EXECUTE || a == FsAction.READ || a == FsAction.EXECUTE || a == FsAction.NONE ? FsAction.READ_EXECUTE.implies(a) : !FsAction.READ_EXECUTE.implies(a)));
        }
        TestFsPermission.assertEquals((Object)FsAction.EXECUTE, (Object)FsAction.EXECUTE.and(FsAction.READ_EXECUTE));
        TestFsPermission.assertEquals((Object)FsAction.READ, (Object)FsAction.READ.and(FsAction.READ_EXECUTE));
        TestFsPermission.assertEquals((Object)FsAction.NONE, (Object)FsAction.WRITE.and(FsAction.READ_EXECUTE));
        TestFsPermission.assertEquals((Object)FsAction.READ, (Object)FsAction.READ_EXECUTE.and(FsAction.READ_WRITE));
        TestFsPermission.assertEquals((Object)FsAction.NONE, (Object)FsAction.READ_EXECUTE.and(FsAction.WRITE));
        TestFsPermission.assertEquals((Object)FsAction.WRITE_EXECUTE, (Object)FsAction.ALL.and(FsAction.WRITE_EXECUTE));
    }

    public void testFsPermission() {
        for (short s = 0; s < 512; s = (short)(s + 1)) {
            TestFsPermission.assertEquals((short)s, (short)new FsPermission(s).toShort());
        }
        String symbolic = "-rwxrwxrwx";
        StringBuilder b = new StringBuilder("-123456789");
        for (int i = 0; i < 512; ++i) {
            for (int j = 1; j < 10; ++j) {
                b.setCharAt(j, '-');
            }
            String binary = Integer.toBinaryString(i);
            int len = binary.length();
            for (int j = 0; j < len; ++j) {
                if (binary.charAt(j) != '1') continue;
                int k = 9 - (len - 1 - j);
                b.setCharAt(k, symbolic.charAt(k));
            }
            TestFsPermission.assertEquals((int)i, (int)FsPermission.valueOf((String)b.toString()).toShort());
        }
    }
}

