/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import java.net.URI;
import junit.framework.TestCase;
import org.apache.ftpserver.DefaultFtpServerContext;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.mina.MinaListener;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.WritePermission;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.mapred.JobConf;

public class TestFTPFileSystem
extends TestCase {
    private Configuration defaultConf = new JobConf();
    private FtpServer server = null;
    private FileSystem localFs = null;
    private FileSystem ftpFs = null;
    private Path workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestFTPFileSystem");
    Path ftpServerRoot = new Path(this.workDir, "FTPServer");
    Path ftpServerConfig = null;

    private void startServer() {
        try {
            DefaultFtpServerContext context = new DefaultFtpServerContext(false);
            MinaListener listener = new MinaListener();
            listener.setPort(0);
            context.setListener("default", (Listener)listener);
            UserManager userManager = context.getUserManager();
            BaseUser adminUser = new BaseUser();
            adminUser.setName("admin");
            adminUser.setPassword("admin");
            adminUser.setEnabled(true);
            adminUser.setAuthorities(new Authority[]{new WritePermission()});
            Path adminUserHome = new Path(this.ftpServerRoot, "user/admin");
            adminUser.setHomeDirectory(adminUserHome.toUri().getPath());
            adminUser.setMaxIdleTime(0);
            userManager.save((User)adminUser);
            this.server = new FtpServer((FtpServerContext)context);
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("FTP server start-up failed", e);
        }
    }

    private void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void setUp() throws Exception {
        this.startServer();
        this.defaultConf = new Configuration();
        this.localFs = FileSystem.getLocal((Configuration)this.defaultConf);
        this.ftpServerConfig = new Path(this.localFs.getWorkingDirectory(), "res");
        MinaListener listener = (MinaListener)this.server.getServerContext().getListener("default");
        int serverPort = listener.getPort();
        this.ftpFs = FileSystem.get((URI)URI.create("ftp://admin:admin@localhost:" + serverPort), (Configuration)this.defaultConf);
    }

    public void tearDown() throws Exception {
        this.localFs.delete(this.ftpServerRoot, true);
        this.localFs.delete(this.ftpServerConfig, true);
        this.localFs.close();
        this.ftpFs.close();
        this.stopServer();
    }

    public void testReadWrite() throws Exception {
        DFSTestUtil util = new DFSTestUtil("TestFTPFileSystem", 20, 3, 0x100000);
        this.localFs.setWorkingDirectory(this.workDir);
        Path localData = new Path(this.workDir, "srcData");
        Path remoteData = new Path("srcData");
        util.createFiles(this.localFs, localData.toUri().getPath());
        boolean dataConsistency = util.checkFiles(this.localFs, localData.getName());
        TestFTPFileSystem.assertTrue((String)"Test data corrupted", (boolean)dataConsistency);
        boolean filesCopied = FileUtil.copy((FileSystem)this.localFs, (Path)localData, (FileSystem)this.ftpFs, (Path)remoteData, (boolean)false, (Configuration)this.defaultConf);
        TestFTPFileSystem.assertTrue((String)"Copying to FTPFileSystem failed", (boolean)filesCopied);
        Path renamedData = new Path("Renamed");
        boolean renamed = this.ftpFs.rename(remoteData, renamedData);
        TestFTPFileSystem.assertTrue((String)"Rename failed", (boolean)renamed);
        filesCopied = FileUtil.copy((FileSystem)this.ftpFs, (Path)renamedData, (FileSystem)this.localFs, (Path)this.workDir, (boolean)true, (Configuration)this.defaultConf);
        TestFTPFileSystem.assertTrue((String)"Copying from FTPFileSystem fails", (boolean)filesCopied);
        dataConsistency = util.checkFiles(this.localFs, renamedData.getName());
        TestFTPFileSystem.assertTrue((String)"Invalid or corrupted data recieved from FTP Server!", (boolean)dataConsistency);
        boolean deleteSuccess = this.localFs.delete(renamedData, true) & this.localFs.delete(localData, true);
        TestFTPFileSystem.assertTrue((String)"Local test data deletion failed", (boolean)deleteSuccess);
    }
}

