/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

public class AccumulatingReducer
extends MapReduceBase
implements Reducer<UTF8, UTF8, UTF8, UTF8> {
    private static final Log LOG = LogFactory.getLog(AccumulatingReducer.class);
    protected String hostName;

    public AccumulatingReducer() {
        LOG.info((Object)"Starting AccumulatingReducer !!!");
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.hostName = "localhost";
        }
        LOG.info((Object)("Starting AccumulatingReducer on " + this.hostName));
    }

    public void reduce(UTF8 key, Iterator<UTF8> values, OutputCollector<UTF8, UTF8> output, Reporter reporter) throws IOException {
        String field = key.toString();
        reporter.setStatus("starting " + field + " ::host = " + this.hostName);
        if (field.startsWith("s:")) {
            String sSum = "";
            while (values.hasNext()) {
                sSum = sSum + values.next().toString() + ";";
            }
            output.collect((Object)key, (Object)new UTF8(sSum));
            reporter.setStatus("finished " + field + " ::host = " + this.hostName);
            return;
        }
        if (field.startsWith("f:")) {
            float fSum = 0.0f;
            while (values.hasNext()) {
                fSum += Float.parseFloat(values.next().toString());
            }
            output.collect((Object)key, (Object)new UTF8(String.valueOf(fSum)));
            reporter.setStatus("finished " + field + " ::host = " + this.hostName);
            return;
        }
        if (field.startsWith("l:")) {
            long lSum = 0L;
            while (values.hasNext()) {
                lSum += Long.parseLong(values.next().toString());
            }
            output.collect((Object)key, (Object)new UTF8(String.valueOf(lSum)));
        }
        reporter.setStatus("finished " + field + " ::host = " + this.hostName);
    }
}

