/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestDistributedCache
extends TestCase {
    static final URI LOCAL_FS = URI.create("file:///");
    private static String TEST_CACHE_BASE_DIR = new Path(System.getProperty("test.build.data", "/tmp/cachebasedir")).toString().replace(' ', '+');
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "/tmp/distributedcache");
    private static final int TEST_FILE_SIZE = 4096;
    private static final int LOCAL_CACHE_LIMIT = 5120;
    private Configuration conf;
    private Path firstCacheFile;
    private Path secondCacheFile;
    private FileSystem localfs;

    protected void setUp() throws IOException {
        this.conf = new Configuration();
        this.conf.setLong("local.cache.size", 5120L);
        this.localfs = FileSystem.get((URI)LOCAL_FS, (Configuration)this.conf);
        this.firstCacheFile = new Path(TEST_ROOT_DIR + "/firstcachefile");
        this.secondCacheFile = new Path(TEST_ROOT_DIR + "/secondcachefile");
        this.createTempFile(this.localfs, this.firstCacheFile);
        this.createTempFile(this.localfs, this.secondCacheFile);
    }

    public void testDeleteCache() throws Exception {
        DistributedCache.getLocalCache((URI)this.firstCacheFile.toUri(), (Configuration)this.conf, (Path)new Path(TEST_CACHE_BASE_DIR), (boolean)false, (long)System.currentTimeMillis(), (Path)new Path(TEST_ROOT_DIR));
        DistributedCache.releaseCache((URI)this.firstCacheFile.toUri(), (Configuration)this.conf);
        DistributedCache.getLocalCache((URI)this.secondCacheFile.toUri(), (Configuration)this.conf, (Path)new Path(TEST_CACHE_BASE_DIR), (boolean)false, (long)System.currentTimeMillis(), (Path)new Path(TEST_ROOT_DIR));
        FileStatus[] dirStatuses = this.localfs.listStatus(new Path(TEST_CACHE_BASE_DIR));
        TestDistributedCache.assertTrue((String)"DistributedCache failed deleting old cache when the cache store is full.", (dirStatuses.length > 1 ? 1 : 0) != 0);
    }

    private void createTempFile(FileSystem fs, Path p) throws IOException {
        FSDataOutputStream out = fs.create(p);
        byte[] toWrite = new byte[4096];
        new Random().nextBytes(toWrite);
        out.write(toWrite);
        out.close();
        FileSystem.LOG.info((Object)("created: " + p + ", size=" + 4096));
    }

    protected void tearDown() throws IOException {
        this.localfs.delete(this.firstCacheFile, true);
        this.localfs.delete(this.secondCacheFile, true);
        this.localfs.close();
    }
}

