/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.ConnectionStrategy;
import org.apache.openejb.client.ServerMetaData;

public class RoundRobinConnectionStrategy
implements ConnectionStrategy {
    private static final Logger LOGGER = Logger.getLogger("OpenEJB.client");

    public Connection connect(ClusterMetaData cluster, ServerMetaData server) throws IOException {
        URI lastLocation;
        List<URI> list;
        URI[] locations;
        Set<URI> failed;
        block11: {
            failed = Client.getFailed();
            locations = cluster.getLocations();
            if (locations.length == 0) {
                return this.connect(cluster, server.getLocation());
            }
            list = Arrays.asList(locations);
            lastLocation = cluster.getLastLocation();
            if (null != lastLocation && !failed.contains(lastLocation)) {
                try {
                    int i = list.indexOf(lastLocation) + 1;
                    if (i >= list.size()) {
                        i = 0;
                    }
                    URI uri = list.get(i);
                    return this.connect(cluster, uri);
                }
                catch (IOException e) {
                    if (locations.length <= 1) break block11;
                    LOGGER.log(Level.WARNING, "RoundRobin: Failing over.  Cannot connect to next server: " + lastLocation.toString() + " Exception: " + e.getClass().getName() + " " + e.getMessage());
                }
            }
        }
        LinkedHashSet<URI> remaining = new LinkedHashSet<URI>(list);
        remaining.remove(lastLocation);
        remaining.removeAll(failed);
        for (URI uri : remaining) {
            try {
                return this.connect(cluster, uri);
            }
            catch (IOException e) {
                failed.add(uri);
                LOGGER.log(Level.WARNING, "RoundRobin: Failover: Cannot connect to server(s): " + uri.toString() + " Exception: " + e.getMessage() + ".  Trying next.");
            }
            catch (Throwable e) {
                failed.add(uri);
                throw new RemoteException("RoundRobin: Failover: Cannot connect to server: " + uri.toString() + " due to an unkown exception in the OpenEJB client: ", e);
            }
        }
        remaining.removeAll(failed);
        if (remaining.size() == 0 && !failed.contains(server.getLocation())) {
            return this.connect(cluster, server.getLocation());
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < locations.length; ++i) {
            URI uri = locations[i];
            buffer.append((i != 0 ? ", " : "") + "Server #" + i + ": " + uri);
        }
        throw new RemoteException("Cannot connect to any servers: " + buffer.toString());
    }

    protected Connection connect(ClusterMetaData cluster, URI uri) throws IOException {
        Connection connection = ConnectionManager.getConnection(uri);
        cluster.setLastLocation(connection.getURI());
        return connection;
    }
}

