/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class PomHelper {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MavenProject readPom(File pomFile) throws MojoExecutionException {
        MavenProject mavenProject;
        FileReader reader = null;
        try {
            reader = new FileReader(pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            mavenProject = new MavenProject(modelReader.read((Reader)reader));
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e2.getMessage(), (Exception)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e3.getMessage(), (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return mavenProject;
    }

    public static MavenProject buildPom(String groupId, String artifactId, String version, String packaging) {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(groupId);
        model.setArtifactId(artifactId);
        model.setVersion(version);
        model.setPackaging(packaging);
        return new MavenProject(model);
    }
}

