/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;

public class DeletePrincipal
implements ContextOperation {
    private static final long serialVersionUID = -6970986279811261983L;
    protected KerberosPrincipal principal;

    public DeletePrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    public Object execute(DirContext ctx, Name searchBaseDn) {
        if (this.principal == null) {
            return null;
        }
        String dn = null;
        try {
            dn = this.search(ctx, searchBaseDn, this.principal.getName());
            Name rdn = this.getRelativeName(ctx, dn);
            ctx.destroySubcontext(rdn);
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
        return dn;
    }

    private String search(DirContext ctx, Name searchBaseDn, String principal) throws NamingException {
        SearchResult sr;
        String[] attrIDs = new String[]{"krb5PrincipalName", "krb5KeyVersionNumber", "krb5EncryptionType", "krb5Key"};
        LockableAttributesImpl matchAttrs = new LockableAttributesImpl(false);
        matchAttrs.put((Attribute)new LockableAttributeImpl("krb5PrincipalName", (Object)principal));
        NamingEnumeration<SearchResult> answer = ctx.search(searchBaseDn, (Attributes)matchAttrs, attrIDs);
        if (answer.hasMore() && (sr = answer.next()) != null) {
            return sr.getName();
        }
        return null;
    }

    private Name getRelativeName(DirContext ctx, String baseDn) throws NamingException {
        CompoundName searchBaseDn;
        Properties props = new Properties();
        props.setProperty("jndi.syntax.direction", "right_to_left");
        props.setProperty("jndi.syntax.separator", ",");
        props.setProperty("jndi.syntax.ignorecase", "true");
        props.setProperty("jndi.syntax.trimblanks", "true");
        try {
            CompoundName ctxRoot = new CompoundName(ctx.getNameInNamespace(), props);
            searchBaseDn = new CompoundName(baseDn, props);
            if (!searchBaseDn.startsWith(ctxRoot)) {
                throw new NamingException("Invalid search base " + baseDn);
            }
            for (int ii = 0; ii < ctxRoot.size(); ++ii) {
                searchBaseDn.remove(0);
            }
        }
        catch (NamingException e) {
            throw new NamingException("Failed to initialize search base " + baseDn);
        }
        return searchBaseDn;
    }
}

