/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class FloatingPoint {
    public static final int IEEE_754_FLOATING_POINT = 72;

    private FloatingPoint() {
    }

    private static final int convertFromByteToInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static final long convertFromByteToLong(byte[] byArray, int n) {
        return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final float getFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n));
    }

    public static final double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(byArray, n));
    }

    public static final void floatToIeee754Bytes(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        byArray[n] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public static final void doubleToIeee754Bytes(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        byArray[n] = (byte)(l >>> 56 & 0xFFL);
        byArray[n + 1] = (byte)(l >>> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l >>> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l >>> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l >>> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l >>> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l >>> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l & 0xFFL);
    }
}

