/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.jaxws.AsyncCallbackFuture;
import org.apache.cxf.jaxws.AsyncResponse;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.DispatchAsyncCallable;
import org.apache.cxf.jaxws.handler.logical.DispatchLogicalHandlerInterceptor;
import org.apache.cxf.jaxws.handler.soap.DispatchSOAPHandlerInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchInDatabindingInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchOutDatabindingInterceptor;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
extends BindingProviderImpl
implements Dispatch<T>,
MessageObserver {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private static final String FINISHED = "exchange.finished";
    private Bus bus;
    private InterceptorProvider iProvider;
    private Class<T> cl;
    private Executor executor;
    private JAXBContext context;
    private Service.Mode mode;
    private ConduitSelector conduitSelector;

    DispatchImpl(Bus b, Client client, Service.Mode m, JAXBContext ctx, Class<T> clazz, Executor e) {
        super(((JaxWsEndpointImpl)client.getEndpoint()).getJaxwsBinding());
        this.bus = b;
        this.iProvider = client;
        this.executor = e;
        this.context = ctx;
        this.cl = clazz;
        this.mode = m;
        this.getConduitSelector().setEndpoint(client.getEndpoint());
        this.setupEndpointAddressContext(client.getEndpoint());
    }

    DispatchImpl(Bus b, Client cl, Service.Mode m, Class<T> clazz, Executor e) {
        this(b, cl, m, null, clazz, e);
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            Map<String, Object> requestContext = this.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invoke(T obj, boolean isOneWay) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Dispatch: invoke called");
        }
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        Endpoint endpoint = this.getEndpoint();
        Message message = endpoint.getBinding().createMessage();
        if (this.context != null) {
            message.setContent(JAXBContext.class, (Object)this.context);
        }
        HashMap<String, Object> reqContext = new HashMap<String, Object>(this.getRequestContext());
        Map<String, Object> respContext = this.getResponseContext();
        respContext.clear();
        ContextPropertiesMapping.mapRequestfromJaxws2Cxf(reqContext);
        message.putAll(reqContext);
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setOneWay(isOneWay);
        exchange.setOutMessage(message);
        this.setExchangeProperties((Exchange)exchange, endpoint);
        message.setContent(Object.class, obj);
        if (obj instanceof SOAPMessage) {
            message.setContent(SOAPMessage.class, obj);
        } else if (obj instanceof Source) {
            message.setContent(Source.class, obj);
        } else if (obj instanceof DataSource) {
            message.setContent(DataSource.class, obj);
        }
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        PhaseInterceptorChain chain = this.getDispatchOutChain(endpoint);
        message.setInterceptorChain((InterceptorChain)chain);
        this.prepareConduitSelector(message);
        chain.doIntercept(message);
        Exception exp = (Exception)message.getContent(Exception.class);
        if (exp == null && exchange.getInMessage() != null) {
            exp = (Exception)exchange.getInMessage().getContent(Exception.class);
        }
        if (exp != null) {
            this.getConduitSelector().complete((Exchange)exchange);
            if (this.getBinding() instanceof SOAPBinding && exp instanceof Fault) {
                try {
                    SOAPFault soapFault = SOAPFactory.newInstance().createFault();
                    Fault fault = (Fault)exp;
                    soapFault.setFaultCode(fault.getFaultCode());
                    soapFault.setFaultString(fault.getMessage());
                    throw new SOAPFaultException(soapFault);
                }
                catch (SOAPException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)exp);
                throw exception;
            }
            throw new WebServiceException((Throwable)exp);
        }
        if (this.getConduitSelector().selectConduit(message).getBackChannel() != null) {
            // empty if block
        }
        if (!isOneWay) {
            ExchangeImpl exchangeImpl = exchange;
            synchronized (exchangeImpl) {
                Message inMsg = this.waitResponse((Exchange)exchange);
                respContext.putAll((Map<String, Object>)inMsg);
                this.getConduitSelector().complete((Exchange)exchange);
                ContextPropertiesMapping.mapResponsefromCxf2Jaxws(respContext);
                T t = this.cl.cast(inMsg.getContent(Object.class));
                return t;
            }
        }
        T t = null;
        return t;
        finally {
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    private Message waitResponse(Exchange exchange) {
        while (!Boolean.TRUE.equals(exchange.get((Object)FINISHED))) {
            try {
                exchange.wait();
            }
            catch (InterruptedException e) {}
        }
        Message inMsg = exchange.getInMessage();
        if (inMsg == null) {
            try {
                exchange.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            inMsg = exchange.getInMessage();
        }
        if (inMsg.getContent(Exception.class) != null) {
            throw new RuntimeException((Throwable)inMsg.getContent(Exception.class));
        }
        return inMsg;
    }

    private PhaseInterceptorChain getDispatchOutChain(Endpoint endpoint) {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getOutPhases());
        List il = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add((Collection)il);
        List i2 = this.iProvider.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i2);
        }
        chain.add((Collection)i2);
        if (endpoint instanceof JaxWsEndpointImpl) {
            Binding jaxwsBinding = ((JaxWsEndpointImpl)endpoint).getJaxwsBinding();
            if (endpoint.getBinding() instanceof SoapBinding) {
                chain.add((Interceptor)new DispatchSOAPHandlerInterceptor(jaxwsBinding));
            }
            chain.add(new DispatchLogicalHandlerInterceptor(jaxwsBinding));
        }
        if (this.getBinding() instanceof SOAPBinding) {
            chain.add((Interceptor)new SoapPreProtocolOutInterceptor());
        }
        chain.add((Interceptor)new MessageSenderInterceptor());
        chain.add((Interceptor)new DispatchOutDatabindingInterceptor(this.mode));
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Endpoint endpoint = this.getEndpoint();
        message = endpoint.getBinding().createMessage(message);
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getInPhases());
        message.setInterceptorChain((InterceptorChain)chain);
        List il = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add((Collection)il);
        List i2 = this.iProvider.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i2);
        }
        chain.add((Collection)i2);
        if (endpoint instanceof JaxWsEndpointImpl) {
            Binding jaxwsBinding = ((JaxWsEndpointImpl)endpoint).getJaxwsBinding();
            if (endpoint.getBinding() instanceof SoapBinding) {
                chain.add((Interceptor)new DispatchSOAPHandlerInterceptor(jaxwsBinding));
            }
            DispatchLogicalHandlerInterceptor slhi = new DispatchLogicalHandlerInterceptor(jaxwsBinding, "user-logical");
            chain.add(slhi);
        }
        ArrayList<DispatchInDatabindingInterceptor> inInterceptors = new ArrayList<DispatchInDatabindingInterceptor>();
        inInterceptors.add(new DispatchInDatabindingInterceptor(this.cl, this.mode));
        chain.add(inInterceptors);
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        try {
            chain.doIntercept(message);
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().put((Object)FINISHED, (Object)Boolean.TRUE);
                message.getExchange().setInMessage(message);
                message.getExchange().notifyAll();
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    private Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getEndpoint().getService().getExecutor();
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(5);
        }
        if (this.executor == null) {
            System.err.println("Can't not get executor");
        }
        return this.executor;
    }

    private Endpoint getEndpoint() {
        return this.getConduitSelector().getEndpoint();
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        Response<T> r = this.invokeAsync(obj);
        AsyncCallbackFuture callback = new AsyncCallbackFuture(r, asyncHandler);
        this.getExecutor().execute(callback);
        return callback;
    }

    public Response<T> invokeAsync(T obj) {
        FutureTask<T> f = new FutureTask<T>(new DispatchAsyncCallable<T>(this, obj));
        this.getExecutor().execute(f);
        return new AsyncResponse<T>(f, this.cl);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }

    public synchronized ConduitSelector getConduitSelector() {
        if (null == this.conduitSelector) {
            this.conduitSelector = new UpfrontConduitSelector();
        }
        return this.conduitSelector;
    }

    public void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector;
    }

    protected void prepareConduitSelector(Message message) {
        message.getExchange().put(ConduitSelector.class, (Object)this.getConduitSelector());
    }

    protected void setExchangeProperties(Exchange exchange, Endpoint endpoint) {
        exchange.put(Service.Mode.class, (Object)this.mode);
        exchange.put(Class.class, this.cl);
        exchange.put(Service.class, (Object)endpoint.getService());
        exchange.put(Endpoint.class, (Object)endpoint);
        exchange.put(MessageObserver.class, (Object)this);
        exchange.put(Bus.class, (Object)this.bus);
        if (endpoint != null) {
            EndpointInfo endpointInfo = endpoint.getEndpointInfo();
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
            URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", (Object)wsdlDescription);
            }
            exchange.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlDescription);
        }
    }
}

