/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.builders.AlgorithmSuiteBuilder;
import org.apache.cxf.ws.security.policy.builders.LayoutBuilder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokens12Builder;
import org.apache.cxf.ws.security.policy.builders.SupportingTokensBuilder;
import org.apache.cxf.ws.security.policy.builders.TransportTokenBuilder;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.policy.model.TransportToken;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportBindingBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.TRANSPORT_BINDING, SP12Constants.TRANSPORT_BINDING);
    PolicyBuilder builder;

    public TransportBindingBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    @Override
    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        TransportBinding transportBinding = new TransportBinding(consts);
        this.processAlternative(element, transportBinding, consts);
        return transportBinding;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    private void processAlternative(Element element, TransportBinding parent, SPConstants consts) {
        Element polEl = DOMUtils.getFirstElement(element);
        while (polEl != null) {
            if (PolicyConstants.isPolicyElem(new QName(polEl.getNamespaceURI(), polEl.getLocalName()))) {
                Element child = DOMUtils.getFirstElement(polEl);
                while (child != null) {
                    String name = child.getLocalName();
                    if (name.equals("AlgorithmSuite")) {
                        parent.setAlgorithmSuite((AlgorithmSuite)new AlgorithmSuiteBuilder().build(child));
                    } else if (name.equals("TransportToken")) {
                        parent.setTransportToken((TransportToken)new TransportTokenBuilder(this.builder).build(child));
                    } else if (name.equals("IncludeTimestamp")) {
                        parent.setIncludeTimestamp(true);
                    } else if (name.equals("Layout")) {
                        parent.setLayout((Layout)new LayoutBuilder().build(child));
                    } else if (name.equals("ProtectTokens")) {
                        parent.setTokenProtection(true);
                    } else if (name.equals("SignedSupportingTokens") || name.equals("SignedEndorsingSupportingTokens")) {
                        if (consts.getVersion() == SPConstants.Version.SP_V11) {
                            parent.setSignedSupportingToken((SupportingToken)new SupportingTokensBuilder(this.builder).build(child));
                        } else {
                            parent.setSignedSupportingToken((SupportingToken)new SupportingTokens12Builder(this.builder).build(child));
                        }
                    }
                    child = DOMUtils.getNextElement(child);
                }
            }
            polEl = DOMUtils.getNextElement(polEl);
        }
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

